/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.control;

import com.ur.polyscope.installation.resource.ResourceControlRequestService;
import com.ur.polyscope.installation.resource.ResourceControllerInfo;
import com.ur.polyscope.io.impl.tool.control.ToolIOControlRequestImpl;
import com.ur.polyscope.io.tool.control.ToolIOControlRequest;
import com.ur.polyscope.io.tool.control.ToolIOControlRequestProvider;
import com.ur.polyscope.urcaps.ExceptionHandler;
import com.ur.urcap.api.domain.resource.tooliointerface.control.ToolIOInterfaceController;
import java.util.ArrayList;
import javax.inject.Inject;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ToolIOControlRequestProviderImpl
implements ToolIOControlRequestProvider {
    private final ExceptionHandler exceptionHandler;
    private final ResourceControlRequestService resourceControlRequestService;

    @Inject
    public ToolIOControlRequestProviderImpl(ResourceControlRequestService resourceControlRequestService, ExceptionHandler exceptionHandler) {
        this.resourceControlRequestService = resourceControlRequestService;
        this.exceptionHandler = exceptionHandler;
    }

    public ToolIOControlRequest[] get() {
        ArrayList<ToolIOControlRequest> requests = this.collectRequests();
        return requests.toArray(new ToolIOControlRequest[0]);
    }

    private ArrayList<ToolIOControlRequest> collectRequests() {
        Object[] requests = this.resourceControlRequestService.getRequests(ToolIOInterfaceController.class);
        ArrayList<ToolIOControlRequest> requestsList = new ArrayList<ToolIOControlRequest>();
        Object[] objectArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            Object toolIOInterfaceController = objectArray[n2];
            ToolIOControlRequest request = this.createRequest((ToolIOInterfaceController)toolIOInterfaceController);
            requestsList.add(request);
            ++n2;
        }
        return requestsList;
    }

    private ToolIOControlRequest createRequest(ToolIOInterfaceController controller) {
        ResourceControllerInfo info = this.createInfo(controller);
        return new ToolIOControlRequestImpl(info, controller, this.exceptionHandler);
    }

    private ResourceControllerInfo createInfo(ToolIOInterfaceController contribution) {
        Bundle bundle = this.getBundle(contribution);
        String ownerId = bundle.getSymbolicName();
        String classId = contribution.getClass().getCanonicalName();
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        String vendor = (String)bundle.getHeaders().get("Bundle-Vendor");
        vendor = vendor == null ? "UNKNOWN" : vendor;
        return new ResourceControllerInfo(String.valueOf(ownerId) + ":" + classId, name, vendor);
    }

    protected Bundle getBundle(ToolIOInterfaceController contribution) {
        return FrameworkUtil.getBundle(contribution.getClass());
    }
}

