/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.control;

import com.ur.polyscope.installation.resource.ResourceControlRequest;
import com.ur.polyscope.installation.resource.ResourceControlService;
import com.ur.polyscope.installation.resource.ResourceControlStrategy;
import com.ur.polyscope.io.impl.tool.control.ToolIOControlServiceListener;
import com.ur.polyscope.io.impl.tool.urcap.TooIOControlStrategy;
import com.ur.polyscope.io.tool.control.ToolIOControlRequest;
import com.ur.polyscope.io.tool.control.ToolIOControlService;
import com.ur.urcap.api.domain.resource.tooliointerface.control.ToolIOInterfaceControllable;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ToolIOControlServiceImpl
implements ToolIOControlService {
    public static final String RESOURCE_ID = "ToolIOInterfaceControllable";
    private final ToolIOInterfaceControllable controllable;
    private final ResourceControlService resourceControlService;
    private final Provider<TooIOControlStrategy> tooIOControlStrategyProvider;
    private final EventManager eventManager;

    @Inject
    public ToolIOControlServiceImpl(ToolIOInterfaceControllable controllable, ResourceControlService resourceControlService, Provider<TooIOControlStrategy> tooIOControlStrategyProvider, EventManager eventManager) {
        this.controllable = controllable;
        this.resourceControlService = resourceControlService;
        this.tooIOControlStrategyProvider = tooIOControlStrategyProvider;
        this.eventManager = eventManager;
        this.initialize();
    }

    public void clear() {
        List requests = this.resourceControlService.getRequestsByResourceId(RESOURCE_ID);
        for (ResourceControlRequest request : requests) {
            this.resourceControlService.removeRequest(request);
        }
    }

    public void requestControl(ToolIOControlRequest ... requests) {
        ToolIOControlRequest[] toolIOControlRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            ToolIOControlRequest request = toolIOControlRequestArray[n2];
            this.resourceControlService.requestControl((ResourceControlRequest)request);
            ++n2;
        }
        this.fireEvent(ToolIOControlServiceListener.EventType.REQUESTED);
    }

    public void grantControl(ToolIOControlRequest request) {
        this.resourceControlService.grantControl((ResourceControlRequest)request);
        this.fireEvent(ToolIOControlServiceListener.EventType.GRANTED);
    }

    public void revokeControl() {
        this.resourceControlService.revokeControl(RESOURCE_ID);
        this.fireEvent(ToolIOControlServiceListener.EventType.REVOKED);
    }

    public ToolIOControlRequest[] requests() {
        ArrayList<ToolIOControlRequest> list = new ArrayList<ToolIOControlRequest>();
        for (ResourceControlRequest request : this.resourceControlService.getRequestsByResourceId(RESOURCE_ID)) {
            if (!(request instanceof ToolIOControlRequest)) continue;
            list.add((ToolIOControlRequest)request);
        }
        ToolIOControlRequest[] array = new ToolIOControlRequest[list.size()];
        return list.toArray(array);
    }

    private void initialize() {
        Provider provider = new Provider(){

            public Object get() {
                return ToolIOControlServiceImpl.this.controllable;
            }
        };
        this.resourceControlService.registerResource(RESOURCE_ID, provider, (ResourceControlStrategy)this.tooIOControlStrategyProvider.get());
    }

    private void fireEvent(ToolIOControlServiceListener.EventType type) {
        final ToolIOControlServiceListener.Event event = new ToolIOControlServiceListener.Event(type);
        this.eventManager.fireEvent(ToolIOControlServiceListener.class, (NotificationStrategy)new NotificationStrategy<ToolIOControlServiceListener>(){

            public void notify(ToolIOControlServiceListener listener) {
                listener.onToolIOControlServiceEvent(event);
            }
        });
    }
}

