/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.stream;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.PackageConsumer;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.io.impl.tool.stream.ToolCommInfoModelSource;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.toolcomm.BaudRate;
import com.ur.view.constants.toolcomm.Parity;
import com.ur.view.constants.toolcomm.StopBits;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class ToolCommPackageConsumer
implements RobotStatePackageConsumer {
    private static final int SIZE_IN_BYTES = PackageConsumer.NumberOf.booleans((int)1) + PackageConsumer.NumberOf.integers((int)3) + PackageConsumer.NumberOf.floats((int)2);
    private ToolCommInfoModelSource toolCommInfoModelSource;

    @Inject
    public ToolCommPackageConsumer(ToolCommInfoModelSource toolCommInfoModelSource) {
        this.toolCommInfoModelSource = toolCommInfoModelSource;
    }

    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.TOOL_COMM_INFO;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        boolean enabled = stream.readBoolean();
        BaudRate baudRate = BaudRate.byId((int)stream.readInt());
        Parity parity = Parity.byId((int)stream.readInt());
        StopBits stopBits = StopBits.byId((int)stream.readInt());
        float rxIdleChars = stream.readFloat();
        float txIdleChars = stream.readFloat();
        ToolCommInfo toolCommInfo = new ToolCommInfo(enabled, baudRate, parity, stopBits, rxIdleChars, txIdleChars);
        this.toolCommInfoModelSource.emit(toolCommInfo);
        return SIZE_IN_BYTES;
    }

    public void initialize(RobotState robotState) {
    }
}

