/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.stream;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.PackageConsumer;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.io.impl.tool.ToolIOService;
import com.ur.polyscope.io.impl.tool.ToolModeViewModel;
import com.ur.polyscope.io.impl.tool.stream.ToolModeModelSource;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.dev.ToolDigitalOutputMode;
import com.ur.view.constants.dev.ToolOutputMode;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class ToolModePackageConsumer
implements RobotStatePackageConsumer {
    private ToolModeModelSource modelSource;
    private final ToolIOService toolIOService;

    @Inject
    public ToolModePackageConsumer(ToolModeModelSource modelSource, ToolIOService toolIOService) {
        this.modelSource = modelSource;
        this.toolIOService = toolIOService;
    }

    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.TOOL_OUTPUT_INFO;
    }

    public int consume(DataInput dataInput, int i) throws IOException {
        ToolOutputMode toolOutputMode = ToolOutputMode.byId((int)dataInput.readByte());
        ToolDigitalOutputMode digitalMode0 = ToolDigitalOutputMode.byId((int)dataInput.readByte());
        ToolDigitalOutputMode digitalMode1 = ToolDigitalOutputMode.byId((int)dataInput.readByte());
        Voltage toolOutputVoltage = this.toolIOService.getToolVoltage();
        this.modelSource.emit(new ToolModeViewModel(toolOutputMode, digitalMode0, digitalMode1, toolOutputVoltage));
        return PackageConsumer.NumberOf.bytes((int)3);
    }

    public void initialize(RobotState robotState) {
    }
}

