/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.urcap;

import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.RxIdleCharsValidators;
import com.ur.polyscope.io.impl.tool.ToolIOService;
import com.ur.polyscope.io.impl.tool.TxIdleCharsValidators;
import com.ur.polyscope.io.impl.tool.urcap.AnalogInputModeConfigApplier;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.resource.tooliointerface.AnalogInputDomainConfig;
import com.ur.urcap.api.domain.resource.tooliointerface.AnalogInputModeConfig;
import com.ur.urcap.api.domain.resource.tooliointerface.CommunicationInterfaceConfig;
import com.ur.view.constants.toolcomm.BaudRate;
import com.ur.view.constants.toolcomm.Parity;
import com.ur.view.constants.toolcomm.StopBits;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AnalogInputModeConfigApplierImpl
implements AnalogInputModeConfigApplier {
    private ToolIOService toolIOService;
    private ValidationStrategy rxIdleCharsValidator;
    private ValidationStrategy txIdleCharsValidator;

    @Inject
    public AnalogInputModeConfigApplierImpl(ToolIOService toolIOService, RxIdleCharsValidators rxIdleCharsValidators, TxIdleCharsValidators txIdleCharsValidators) {
        this.toolIOService = toolIOService;
        this.rxIdleCharsValidator = rxIdleCharsValidators.getRxIdleCharsValidatorEN();
        this.txIdleCharsValidator = txIdleCharsValidators.getTxIdleCharsValidatorEN();
    }

    @Override
    public void apply(AnalogInputModeConfig analogInputModeConfig) {
        switch (analogInputModeConfig.getConfigType()) {
            case ANALOG_INPUT_DOMAIN: {
                this.setAnalogToolModeConfig((AnalogInputDomainConfig)analogInputModeConfig);
                break;
            }
            case TOOL_COMMUNICATION_INTERFACE: {
                this.setToolCommunicationInterface((CommunicationInterfaceConfig)analogInputModeConfig);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tool input mode config:" + analogInputModeConfig);
            }
        }
    }

    private void setAnalogToolModeConfig(AnalogInputDomainConfig analogInputDomainConfig) {
        this.disableToolCommInfo();
        this.toolIOService.setAnalogInputDomains(this.convertAnalogDomain(analogInputDomainConfig.getAnalogDomainForInput0()), this.convertAnalogDomain(analogInputDomainConfig.getAnalogDomainForInput1()));
    }

    private void disableToolCommInfo() {
        ToolCommInfo toolCommInfo = this.toolIOService.getToolCommInfo();
        ToolCommInfo disabledToolCommInfo = this.createDisabledToolCommInfo(toolCommInfo);
        this.setToolCommInfo(disabledToolCommInfo);
    }

    private ToolCommInfo createDisabledToolCommInfo(ToolCommInfo toolCommInfo) {
        return new ToolCommInfo(false, toolCommInfo.getBaudRate(), toolCommInfo.getParity(), toolCommInfo.getStopBits(), toolCommInfo.getRxIdleChars(), toolCommInfo.getTxIdleChars());
    }

    private void setToolCommunicationInterface(CommunicationInterfaceConfig communicationInterfaceConfig) {
        ToolCommInfo toolCommInfo = this.createToolCommInfo(communicationInterfaceConfig);
        this.setToolCommInfo(toolCommInfo);
    }

    protected void setToolCommInfo(ToolCommInfo toolCommInfo) {
        this.toolIOService.setToolCommInfo(toolCommInfo);
    }

    private ToolCommInfo createToolCommInfo(CommunicationInterfaceConfig communicationInterfaceConfig) {
        BaudRate baudRate = this.convertBaudRate(communicationInterfaceConfig.getBaudRate());
        Parity parity = this.convertParity(communicationInterfaceConfig.getParity());
        StopBits stopBits = this.convertStopBits(communicationInterfaceConfig.getStopBits());
        this.assertValid(communicationInterfaceConfig.getRxIdleChars(), this.rxIdleCharsValidator);
        this.assertValid(communicationInterfaceConfig.getTxIdleChars(), this.txIdleCharsValidator);
        float rxIdleChars = (float)communicationInterfaceConfig.getRxIdleChars();
        float txIdleChars = (float)communicationInterfaceConfig.getTxIdleChars();
        return new ToolCommInfo(true, baudRate, parity, stopBits, rxIdleChars, txIdleChars);
    }

    private AnalogDomain convertAnalogDomain(AnalogInputDomainConfig.AnalogDomain analogDomain) {
        switch (analogDomain) {
            case CURRENT: {
                return AnalogDomain.CURRENT;
            }
            case VOLTAGE: {
                return AnalogDomain.VOLTAGE;
            }
        }
        throw new IllegalArgumentException("Unknown analog domain: " + analogDomain);
    }

    private BaudRate convertBaudRate(CommunicationInterfaceConfig.BaudRate baudRate) {
        switch (baudRate) {
            case BAUD_9600: {
                return BaudRate.BAUD_9600;
            }
            case BAUD_19200: {
                return BaudRate.BAUD_19200;
            }
            case BAUD_38400: {
                return BaudRate.BAUD_38400;
            }
            case BAUD_57600: {
                return BaudRate.BAUD_57600;
            }
            case BAUD_115200: {
                return BaudRate.BAUD_115200;
            }
            case BAUD_1M: {
                return BaudRate.BAUD_1000000;
            }
            case BAUD_2M: {
                return BaudRate.BAUD_2000000;
            }
            case BAUD_5M: {
                return BaudRate.BAUD_5000000;
            }
        }
        throw new IllegalArgumentException("Unknown baud rate: " + baudRate);
    }

    private Parity convertParity(CommunicationInterfaceConfig.Parity parity) {
        switch (parity) {
            case NONE: {
                return Parity.NONE;
            }
            case EVEN: {
                return Parity.EVEN;
            }
            case ODD: {
                return Parity.ODD;
            }
        }
        throw new IllegalArgumentException("Unknown parity: " + parity);
    }

    private StopBits convertStopBits(CommunicationInterfaceConfig.StopBits stopBits) {
        switch (stopBits) {
            case ONE: {
                return StopBits.ONE;
            }
            case TWO: {
                return StopBits.TWO;
            }
        }
        throw new IllegalArgumentException("Unknown stop bits: " + stopBits);
    }

    private void assertValid(double value, ValidationStrategy validator) {
        String valueStr = String.valueOf(value);
        if (!validator.isValid(valueStr)) {
            throw new IllegalArgumentException(validator.getErrorMessage(valueStr));
        }
    }
}

