/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.urcap;

import com.ur.polyscope.io.tool.Voltage;
import com.ur.urcap.api.domain.resource.tooliointerface.DigitalOutputModeConfig;
import com.ur.urcap.api.domain.resource.tooliointerface.StandardDigitalOutputModeConfig;
import com.ur.urcap.api.domain.resource.tooliointerface.ToolIOInterface;
import com.ur.view.constants.dev.ToolDigitalOutputMode;
import com.ur.view.constants.dev.ToolOutputMode;

public class ToolIOConverter {
    private ToolIOConverter() {
    }

    public static Voltage convertOutputVoltage(ToolIOInterface.OutputVoltage outputVoltage) {
        switch (outputVoltage) {
            case OUTPUT_VOLTAGE_0V: {
                return Voltage.ZERO;
            }
            case OUTPUT_VOLTAGE_12V: {
                return Voltage.TWELVE;
            }
            case OUTPUT_VOLTAGE_24V: {
                return Voltage.TWENTY_FOUR;
            }
        }
        return Voltage.ZERO;
    }

    public static ToolIOInterface.OutputVoltage convertVoltage(Voltage voltage) {
        switch (voltage) {
            case ZERO: {
                return ToolIOInterface.OutputVoltage.OUTPUT_VOLTAGE_0V;
            }
            case TWELVE: {
                return ToolIOInterface.OutputVoltage.OUTPUT_VOLTAGE_12V;
            }
            case TWENTY_FOUR: {
                return ToolIOInterface.OutputVoltage.OUTPUT_VOLTAGE_24V;
            }
        }
        return ToolIOInterface.OutputVoltage.OUTPUT_VOLTAGE_0V;
    }

    public static DigitalOutputModeConfig.ConfigType convertToolOutputMode(ToolOutputMode toolOutputMode) {
        switch (toolOutputMode) {
            case POWER: {
                return DigitalOutputModeConfig.ConfigType.DUAL_PIN_POWER_MODE;
            }
            case OUTPUT: {
                return DigitalOutputModeConfig.ConfigType.STANDARD_DIGITAL_OUTPUT_MODE;
            }
        }
        throw new IllegalArgumentException("Unknown ToolOutputMode enum: " + toolOutputMode);
    }

    public static ToolOutputMode convertDigitalOutputModeConfigType(DigitalOutputModeConfig.ConfigType configType) {
        switch (configType) {
            case DUAL_PIN_POWER_MODE: {
                return ToolOutputMode.POWER;
            }
            case STANDARD_DIGITAL_OUTPUT_MODE: {
                return ToolOutputMode.OUTPUT;
            }
        }
        throw new IllegalArgumentException("Unknown ToolOutputModeConfig enum: " + configType);
    }

    public static StandardDigitalOutputModeConfig.OutputMode convertToolDigitalOutputMode(ToolDigitalOutputMode toolDigitalOutputMode) {
        switch (toolDigitalOutputMode) {
            case SOURCING: {
                return StandardDigitalOutputModeConfig.OutputMode.SOURCING_PNP;
            }
            case PUSH_PULL: {
                return StandardDigitalOutputModeConfig.OutputMode.PUSH_PULL;
            }
            case SINKING: {
                return StandardDigitalOutputModeConfig.OutputMode.SINKING_NPN;
            }
        }
        throw new IllegalArgumentException("Unknown ToolDigitalOutputMode enum: " + toolDigitalOutputMode);
    }

    public static ToolDigitalOutputMode convertStandardDigitalOutputModeConfigType(StandardDigitalOutputModeConfig.OutputMode configType) {
        switch (configType) {
            case SOURCING_PNP: {
                return ToolDigitalOutputMode.SOURCING;
            }
            case PUSH_PULL: {
                return ToolDigitalOutputMode.PUSH_PULL;
            }
            case SINKING_NPN: {
                return ToolDigitalOutputMode.SINKING;
            }
        }
        throw new IllegalArgumentException("Unknown DigitalOutputMode enum: " + configType);
    }
}

