/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.view;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.ToolCommInfoPresenter;
import com.ur.polyscope.io.impl.tool.ToolCommInfoView;
import com.ur.polyscope.io.internal.ImageResource;
import com.ur.polyscope.io.internal.TextResource;
import com.ur.polyscope.io.tool.ToolAnalogInputViewModel;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.EnumComboBoxModel;
import com.ur.swing.EnumListCellRenderer;
import com.ur.swing.FormBuilder;
import com.ur.swing.LabelProvider;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.constants.toolcomm.BaudRate;
import com.ur.view.constants.toolcomm.Parity;
import com.ur.view.constants.toolcomm.StopBits;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ToolCommInfoPanel
extends JPanel
implements ToolCommInfoView {
    public static final int RADIO_BUTTON_WIDTH = 36;
    private static final String TOOL_COMM_INFO_PANEL_TOOL_IOSWING_VIEW = "ToolCommInfoPanel.ToolIOSwingView";
    private JComponent warningPanel;
    private JComboBox baudRateComboBox;
    private JComboBox stopBitComboBox;
    private JComboBox parityComboBox;
    private NumberField rxIdleChars;
    private NumberField txIdleChars;
    private ToolCommInfoPresenter presenter;
    private ViewContext viewContext;
    private boolean isUpdatingCard;
    private JRadioButton selectCommunicationInterface;
    private JRadioButton selectAnalogInputs;
    private JLabel toolPin0AnalogIn;
    private JLabel toolPin1AnalogIn;
    private JComboBox pin0AnalogDomain;
    private JComboBox pin1AnalogDomain;

    ToolCommInfoPanel(ToolCommInfoPresenter presenter, HelpIdAssigner helpIdAssigner, ViewContext viewContext) {
        this.presenter = presenter;
        this.viewContext = viewContext;
        this.setName(TOOL_COMM_INFO_PANEL_TOOL_IOSWING_VIEW);
        this.initComponents(viewContext);
        this.setPanelLayout(viewContext);
        this.initHelpIds(helpIdAssigner);
        presenter.setView(this);
    }

    public void enter() {
        this.presenter.modelUpdated();
        this.presenter.startBackgroundService();
    }

    public void exit() {
        this.presenter.stopBackgroundService();
    }

    @Override
    public void initializeView(ToolCommInfoPresenter.ToolCommViewInitializer initializer) {
        this.baudRateComboBox.setRenderer(new EnumListCellRenderer(initializer.baudRates));
        this.parityComboBox.setRenderer(new EnumListCellRenderer(initializer.parities));
        this.stopBitComboBox.setRenderer(new EnumListCellRenderer(initializer.stopBits));
        this.rxIdleChars.setErrorValidationStrategy(new ValidationStrategy[]{initializer.getRxIdleCharsValidator()});
        this.txIdleChars.setErrorValidationStrategy(new ValidationStrategy[]{initializer.getTxIdleCharsValidator()});
    }

    @Override
    public void updateView(ToolAnalogInputViewModel viewData) {
        this.isUpdatingCard = true;
        try {
            Log.debug((String)viewData.toString());
            this.toolPin0AnalogIn.setText(viewData.pin0Name);
            this.toolPin1AnalogIn.setText(viewData.pin1Name);
            this.pin0AnalogDomain.setSelectedItem(viewData.pin0Domain);
            this.pin1AnalogDomain.setSelectedItem(viewData.pin1Domain);
            JRadioButton selected = viewData.enabled ? this.selectCommunicationInterface : this.selectAnalogInputs;
            selected.setSelected(true);
            this.baudRateComboBox.setSelectedItem(viewData.baudRate);
            this.parityComboBox.setSelectedItem(viewData.parity);
            this.stopBitComboBox.setSelectedItem(viewData.stopBits);
            this.rxIdleChars.setValue((Object)Float.valueOf(viewData.rxIdleChars));
            this.txIdleChars.setValue((Object)Float.valueOf(viewData.txIdleChars));
            this.enableForToolCommInfoParameters(viewData.enabled);
        }
        finally {
            this.isUpdatingCard = false;
        }
    }

    private void initComponents(ViewContext viewContext) {
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.selectAnalogInputs = widgetFactory.createRadioButton((Action)((Object)new EnableAnalogCommunication()));
        this.selectAnalogInputs.setText(textResource.analogInputs());
        this.selectAnalogInputs.setName("analogInputs.ToolIOSwingView");
        this.toolPin0AnalogIn = new JLabel("analog_in[2]");
        this.toolPin1AnalogIn = new JLabel("analog_in[3]");
        this.pin0AnalogDomain = widgetFactory.createComboBox((LabelProvider)new AnalogDomainProvider(textResource), (Object[])new AnalogDomain[0]);
        this.pin0AnalogDomain.setModel(new EnumComboBoxModel((Enum[])AnalogDomain.values()));
        this.pin0AnalogDomain.addActionListener(new ToolCommInfoChanged());
        this.pin1AnalogDomain = widgetFactory.createComboBox((LabelProvider)new AnalogDomainProvider(textResource), (Object[])new AnalogDomain[0]);
        this.pin1AnalogDomain.setModel(new EnumComboBoxModel((Enum[])AnalogDomain.values()));
        this.pin1AnalogDomain.addActionListener(new ToolCommInfoChanged());
        this.selectCommunicationInterface = widgetFactory.createRadioButton((Action)((Object)new EnableAnalogCommunication()));
        this.selectCommunicationInterface.setText(textResource.enableToolCommunication());
        this.selectCommunicationInterface.setName("enableButton.ToolIOSwingView");
        this.baudRateComboBox = new JComboBox(new EnumComboBoxModel(BaudRate.class, (Enum[])new BaudRate[]{BaudRate.BAUD_UNKNOWN}));
        this.baudRateComboBox.setName("baudRateComboBox.ToolIOSwingView");
        this.baudRateComboBox.addActionListener(new ToolCommInfoChanged());
        this.parityComboBox = new JComboBox(new EnumComboBoxModel(Parity.class, (Enum[])new Parity[]{Parity.UNKNOWN}));
        this.parityComboBox.setName("parityComboBox.ToolIOSwingView");
        this.parityComboBox.addActionListener(new ToolCommInfoChanged());
        this.rxIdleChars = widgetFactory.createNumberField((ActionListener)new ToolCommInfoChanged());
        this.rxIdleChars.setValueConverter((ValueConverter)new FloatConverter());
        this.rxIdleChars.setName("rxIdleCharsNumberField.ToolIOSwingView");
        this.rxIdleChars.setMode(Mode.PositiveNumbers);
        this.txIdleChars = widgetFactory.createNumberField((ActionListener)new ToolCommInfoChanged());
        this.txIdleChars.setValueConverter((ValueConverter)new FloatConverter());
        this.txIdleChars.setName("txIdleCharsNumberField.ToolIOSwingView");
        this.txIdleChars.setMode(Mode.PositiveNumbers);
        this.stopBitComboBox = new JComboBox(new EnumComboBoxModel(StopBits.class, (Enum[])new StopBits[]{StopBits.UNKNOWN}));
        this.stopBitComboBox.setName("stopBitsComboBox.ToolIOSwingView");
        this.stopBitComboBox.addActionListener(new ToolCommInfoChanged());
        new ButtonGroup(){
            {
                this.add(ToolCommInfoPanel.this.selectAnalogInputs);
                this.add(ToolCommInfoPanel.this.selectCommunicationInterface);
            }
        };
    }

    private void setPanelLayout(ViewContext viewContext) {
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.warningPanel = this.createWarningPanel(textResource.toolCommInstallWarning());
        JLabel description = new JLabel(HTML.html((String)textResource.toolCommInstallDetail()));
        description.setVerticalAlignment(1);
        viewContext.createFormBuilder().component((JComponent)this.selectAnalogInputs, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component(this.indentRadioButtonSize(this.toolPin0AnalogIn), new FormBuilder.PanelConstraints[0]).component((JComponent)this.pin0AnalogDomain, new FormBuilder.PanelConstraints[0]).end().component(this.indentRadioButtonSize(this.toolPin1AnalogIn), new FormBuilder.PanelConstraints[0]).component((JComponent)this.pin1AnalogDomain, new FormBuilder.PanelConstraints[0]).end().end().component((JComponent)this.selectCommunicationInterface, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component(this.indentRadioButtonSize(description), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(3).component(this.indentRadioButtonSize(textResource.baudRate()), new FormBuilder.PanelConstraints[0]).component((JComponent)this.baudRateComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end().component(this.indentRadioButtonSize(textResource.parity()), new FormBuilder.PanelConstraints[0]).component((JComponent)this.parityComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end().component(this.indentRadioButtonSize(textResource.stopBits()), new FormBuilder.PanelConstraints[0]).component((JComponent)this.stopBitComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end().component(this.indentRadioButtonSize(textResource.rxIdleChars()), new FormBuilder.PanelConstraints[0]).component((JComponent)this.rxIdleChars, new FormBuilder.PanelConstraints[0]).end().component(this.indentRadioButtonSize(textResource.txIdleChars()), new FormBuilder.PanelConstraints[0]).component((JComponent)this.txIdleChars, new FormBuilder.PanelConstraints[0]).end().setOnPanel((JPanel)this);
    }

    private JComponent indentRadioButtonSize(String text) {
        return this.indentRadioButtonSize(new JLabel(text));
    }

    private JComponent indentRadioButtonSize(JLabel label) {
        Box result = Box.createHorizontalBox();
        result.add(Box.createHorizontalStrut(36));
        result.add(label);
        return result;
    }

    private void initHelpIds(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId((JComponent)this.selectCommunicationInterface, "gui:installation_Enabling_TCI");
        helpIdAssigner.assignHelpId(this.warningPanel, "gui:installation_Disabled_Analog_Input");
        helpIdAssigner.assignHelpId((JComponent)this.pin0AnalogDomain, "gui:iotab_analog_domain_settings");
        helpIdAssigner.assignHelpId((JComponent)this.pin1AnalogDomain, "gui:iotab_analog_domain_settings");
    }

    private ViewContext getViewContext() {
        return this.viewContext;
    }

    private JComponent createWarningPanel(String text) {
        JLabel warningLabel = this.getViewContext().createWidgetFactory().createLabel(HTML.html((String)text));
        warningLabel.setFont(this.getViewContext().getFontFactory().getRelativeFont(URFontFactory.Style.ITALIC, URFontFactory.Size.SMALL));
        warningLabel.setIcon(ImageResource.formWarning());
        return warningLabel;
    }

    private void enableForToolCommInfoParameters(boolean enable) {
        if (!this.isEnabled()) {
            return;
        }
        this.pin0AnalogDomain.setEnabled(!enable);
        this.pin1AnalogDomain.setEnabled(!enable);
        this.baudRateComboBox.setEnabled(enable);
        this.parityComboBox.setEnabled(enable);
        this.stopBitComboBox.setEnabled(enable);
        this.rxIdleChars.setEnabled(enable);
        this.txIdleChars.setEnabled(enable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.baudRateComboBox.setEnabled(enabled);
        this.stopBitComboBox.setEnabled(enabled);
        this.parityComboBox.setEnabled(enabled);
        this.rxIdleChars.setEnabled(enabled);
        this.rxIdleChars.setBorderEnabled(true);
        this.txIdleChars.setEnabled(enabled);
        this.txIdleChars.setBorderEnabled(true);
        this.selectCommunicationInterface.setEnabled(enabled);
        this.selectAnalogInputs.setEnabled(enabled);
        this.pin0AnalogDomain.setEnabled(enabled);
        this.pin1AnalogDomain.setEnabled(enabled);
    }

    private static class AnalogDomainProvider
    implements LabelProvider<AnalogDomain> {
        private TextResource textResource;

        public AnalogDomainProvider(TextResource textResource) {
            this.textResource = textResource;
        }

        public String getText(AnalogDomain analogDomain) {
            return this.textResource.domain((Enum<AnalogDomain>)analogDomain);
        }
    }

    private class EnableAnalogCommunication
    extends AbstractActionDefinition {
        private EnableAnalogCommunication() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ToolCommInfoPanel.this.isUpdatingCard) {
                return;
            }
            ToolCommInfoPanel.this.enableForToolCommInfoParameters(ToolCommInfoPanel.this.selectCommunicationInterface.isSelected());
            ToolCommInfoPanel.this.presenter.updateModel((AnalogDomain)ToolCommInfoPanel.this.pin0AnalogDomain.getSelectedItem(), (AnalogDomain)ToolCommInfoPanel.this.pin1AnalogDomain.getSelectedItem(), ToolCommInfoPanel.this.selectCommunicationInterface.isSelected(), (BaudRate)ToolCommInfoPanel.this.baudRateComboBox.getSelectedItem(), (Parity)ToolCommInfoPanel.this.parityComboBox.getSelectedItem(), (StopBits)ToolCommInfoPanel.this.stopBitComboBox.getSelectedItem(), ((Float)ToolCommInfoPanel.this.rxIdleChars.getValue()).floatValue(), ((Float)ToolCommInfoPanel.this.txIdleChars.getValue()).floatValue());
        }
    }

    private static class FloatConverter
    implements ValueConverter<String, Float> {
        private FloatConverter() {
        }

        public Float fromGui(String guiValue) {
            return Float.valueOf(PrimitiveUtils.parseFloat((String)guiValue, (float)0.0f));
        }

        public String fromModel(Float modelValue) {
            return String.valueOf(modelValue);
        }

        public String getUnit() {
            return "";
        }

        public Format getFormat() {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.0");
        }
    }

    private class ToolCommInfoChanged
    implements ActionListener {
        private ToolCommInfoChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolCommInfoPanel.this.isUpdatingCard) {
                return;
            }
            ToolCommInfoPanel.this.presenter.updateModel((AnalogDomain)ToolCommInfoPanel.this.pin0AnalogDomain.getSelectedItem(), (AnalogDomain)ToolCommInfoPanel.this.pin1AnalogDomain.getSelectedItem(), ToolCommInfoPanel.this.selectCommunicationInterface.isSelected(), (BaudRate)ToolCommInfoPanel.this.baudRateComboBox.getSelectedItem(), (Parity)ToolCommInfoPanel.this.parityComboBox.getSelectedItem(), (StopBits)ToolCommInfoPanel.this.stopBitComboBox.getSelectedItem(), ((Float)ToolCommInfoPanel.this.rxIdleChars.getValue()).floatValue(), ((Float)ToolCommInfoPanel.this.txIdleChars.getValue()).floatValue());
        }
    }
}

