/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.view;

import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.resource.ResourceControllerInfo;
import com.ur.polyscope.io.impl.tool.control.ToolIOControlServiceListener;
import com.ur.polyscope.io.impl.tool.view.ResourceControllerHeading;
import com.ur.polyscope.io.impl.tool.view.ToolCommInfoPanel;
import com.ur.polyscope.io.impl.tool.view.ToolIOControlRender;
import com.ur.polyscope.io.impl.tool.view.ToolIOControlRenderingStrategy;
import com.ur.polyscope.io.impl.tool.view.ToolModePanel;
import com.ur.polyscope.io.internal.ImageResource;
import com.ur.polyscope.io.internal.TextResource;
import com.ur.polyscope.io.tool.control.ToolIOControlRequest;
import com.ur.polyscope.io.tool.control.ToolIOControlService;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.event.Subscription;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuListener;

public class ToolIOControlPanel
extends JPanel
implements ItemListener,
ToolIOControlServiceListener {
    private static final String CONTROL_COMBOBOX = "controlCombobox.ToolIOSwingView";
    private final transient ToolIOControlService controlService;
    private final transient JLabel controlComboboxLabel;
    private final transient JComboBox controlCombobox;
    private final transient JLabel controlComboboxWarning;
    private final transient ViewContext viewContext;
    private final transient ToolModePanel toolModePanel;
    private final transient ToolCommInfoPanel toolCommInfoPanel;
    private final EventManager eventManager;
    private Subscription toolIOControlServiceSubscription;
    private boolean manualControl = false;
    private String user;
    private final Color UNDEFINED_WARNING = UIManager.getColor("undefined.warning");
    private Border errorBorder;
    private Border originalBorder;
    private Color originalBackground;

    public ToolIOControlPanel(ToolIOControlService controlService, ViewContext viewContext, HelpIdAssigner helpIdAssigner, ToolModePanel toolModePanel, ToolCommInfoPanel toolCommInfoPanel, EventManager eventManager) {
        this.controlService = controlService;
        this.viewContext = viewContext;
        this.controlCombobox = viewContext.createWidgetFactory().createComboBox();
        this.controlCombobox.setName(CONTROL_COMBOBOX);
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        String labelText = textResource.controlledBy();
        this.controlComboboxLabel = viewContext.createWidgetFactory().createLabel(labelText);
        String text = textResource.ioInterfaceControlWarning();
        this.controlComboboxWarning = viewContext.createWidgetFactory().createLabel(text);
        this.controlComboboxWarning.setIcon(ImageResource.formWarning());
        this.toolModePanel = toolModePanel;
        this.toolCommInfoPanel = toolCommInfoPanel;
        this.eventManager = eventManager;
        this.initialize();
        this.initHelpIds(helpIdAssigner);
    }

    public void enter() {
        this.updateCombobox();
        this.updateControlState();
        this.controlCombobox.addItemListener(this);
        if (this.manualControl) {
            this.setEnableSubPanels(true);
        } else {
            this.setEnableSubPanels(false);
        }
        this.enterSubPanels();
        this.subscribeToolIOControlServiceListener();
    }

    public void exit() {
        this.unsubscribeToolIOControlServiceListener();
        this.exitSubPanels();
        this.controlCombobox.removeItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Object selected = this.controlCombobox.getSelectedItem();
            if (selected instanceof ResourceControllerInfo) {
                this.grantControl(((ResourceControllerInfo)selected).getId());
            } else {
                this.revokeControl();
            }
        }
    }

    private void revokeControl() {
        this.controlService.revokeControl();
        this.setManualControl(true);
    }

    private void grantControl(String id) {
        ToolIOControlRequest request = this.getRequestById(id);
        if (request == null) {
            this.revokeControl();
        } else {
            ToolIOControlRequest activeRequest = this.getActiveRequest();
            if (activeRequest == null || !activeRequest.getResourceControllerInfo().getId().equals(id)) {
                this.controlService.grantControl(request);
                this.setManualControl(false);
            }
        }
    }

    private ToolIOControlRequest getActiveRequest() {
        ToolIOControlRequest[] toolIOControlRequestArray = this.controlService.requests();
        int n = toolIOControlRequestArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolIOControlRequest request = toolIOControlRequestArray[n2];
            if (request.hasControl()) {
                return request;
            }
            ++n2;
        }
        return null;
    }

    private ToolIOControlRequest getRequestById(String id) {
        ToolIOControlRequest[] toolIOControlRequestArray = this.controlService.requests();
        int n = toolIOControlRequestArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolIOControlRequest request = toolIOControlRequestArray[n2];
            if (request.getResourceControllerInfo().getId().equals(id)) {
                return request;
            }
            ++n2;
        }
        return null;
    }

    private void initialize() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.user = textResource.USER();
        ToolIOControlRenderingStrategy renderingStrategy = new ToolIOControlRenderingStrategy();
        this.controlCombobox.setRenderer(new ToolIOControlRender(renderingStrategy));
        this.controlCombobox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer((RenderingStrategy)renderingStrategy, 700));
        JPanel horizontalBox = new JPanel();
        horizontalBox.setLayout(new BoxLayout(horizontalBox, 2));
        Dimension labelDimension = new Dimension(220, 32);
        this.controlComboboxLabel.setMaximumSize(labelDimension);
        this.controlComboboxLabel.setMinimumSize(labelDimension);
        this.controlComboboxLabel.setPreferredSize(labelDimension);
        horizontalBox.add(this.controlComboboxLabel);
        Dimension comboboxDimension = new Dimension(236, 32);
        horizontalBox.add(Box.createRigidArea(new Dimension(20, 0)));
        this.controlCombobox.setMaximumSize(comboboxDimension);
        this.controlCombobox.setMinimumSize(comboboxDimension);
        this.controlCombobox.setPreferredSize(comboboxDimension);
        horizontalBox.add(this.controlCombobox);
        horizontalBox.add(Box.createRigidArea(new Dimension(33, 0)));
        horizontalBox.add(this.controlComboboxWarning);
        JPanel panel = new JPanel();
        this.viewContext.createFormBuilder().description(textResource.ioInterfaceControlDetails(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).component((JComponent)horizontalBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().setOnPanel(panel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.75;
        c.gridx = 0;
        c.fill = 1;
        this.add((Component)panel, c);
        this.originalBorder = this.controlCombobox.getBorder();
        this.originalBackground = this.controlCombobox.getBackground();
        AbstractBorder insets = new EmptyBorder(new Insets(1, 1, 1, 1));
        if (this.originalBorder != null) {
            insets = new CompoundBorder(insets, this.originalBorder);
        }
        this.errorBorder = new CompoundBorder(new LineBorder(this.UNDEFINED_WARNING, 2), insets);
    }

    @Override
    public synchronized void onToolIOControlServiceEvent(ToolIOControlServiceListener.Event event) {
        if (event.getType() != ToolIOControlServiceListener.EventType.GRANTED && event.getType() != ToolIOControlServiceListener.EventType.REVOKED && event.getType() != ToolIOControlServiceListener.EventType.REQUESTED) {
            return;
        }
        this.controlCombobox.removeItemListener(this);
        this.updateCombobox();
        this.updateControlState();
        this.controlCombobox.addItemListener(this);
    }

    private void updateCombobox() {
        this.controlCombobox.setModel(this.getContollerComboBoxModel());
        boolean missingIsActive = false;
        ToolIOControlRequest activeRequest = this.getActiveRequest();
        if (activeRequest != null) {
            this.controlCombobox.setSelectedItem(activeRequest.getResourceControllerInfo());
            if (activeRequest.getResourceControllerInfo().isMissing()) {
                missingIsActive = true;
            }
        }
        if (missingIsActive) {
            this.controlComboboxWarning.setVisible(true);
            this.controlCombobox.setBorder(this.errorBorder);
            this.controlCombobox.setFont(this.getFont().deriveFont(2));
        } else {
            this.controlComboboxWarning.setVisible(false);
            this.controlCombobox.setFont(this.getFont().deriveFont(0));
            this.controlCombobox.setBorder(this.originalBorder);
            this.controlCombobox.setBackground(this.originalBackground);
        }
    }

    private Map<ResourceControllerHeading, List<ResourceControllerInfo>> getResourceControllerVendorMap() {
        TreeMap<ResourceControllerHeading, List<ResourceControllerInfo>> resourceControllerVendorMap = new TreeMap<ResourceControllerHeading, List<ResourceControllerInfo>>();
        ToolIOControlRequest[] toolIOControlRequestArray = this.controlService.requests();
        int n = toolIOControlRequestArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolIOControlRequest request = toolIOControlRequestArray[n2];
            ResourceControllerInfo info = request.getResourceControllerInfo();
            ResourceControllerHeading heading = new ResourceControllerHeading(info.getVendorName());
            ArrayList<ResourceControllerInfo> resourceControllerInfos = (ArrayList<ResourceControllerInfo>)resourceControllerVendorMap.get(heading);
            if (resourceControllerInfos == null) {
                resourceControllerInfos = new ArrayList<ResourceControllerInfo>();
            }
            resourceControllerInfos.add(info);
            resourceControllerVendorMap.put(heading, resourceControllerInfos);
            ++n2;
        }
        return resourceControllerVendorMap;
    }

    private void setControlomboBoxModel(ControllerComboBoxModel model) {
        model.removeAllElements();
        model.addElement(this.user);
        Map<ResourceControllerHeading, List<ResourceControllerInfo>> vendorMap = this.getResourceControllerVendorMap();
        for (Map.Entry<ResourceControllerHeading, List<ResourceControllerInfo>> entry : vendorMap.entrySet()) {
            model.addElement(entry.getKey());
            for (ResourceControllerInfo info : entry.getValue()) {
                model.addElement(info);
            }
        }
    }

    private void updateControlState() {
        ToolIOControlRequest activeRequest = this.getActiveRequest();
        if (activeRequest == null) {
            this.setManualControlWithoutNotification(true);
        } else {
            this.setManualControlWithoutNotification(false);
        }
    }

    private void setManualControl(boolean value) {
        if (this.setManualControlWithoutNotification(value)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolIOControlPanel.this.fireInstallationChangedEvent();
                }
            });
        }
    }

    private boolean setManualControlWithoutNotification(boolean value) {
        if (this.manualControl == value) {
            return false;
        }
        this.manualControl = value;
        if (this.manualControl) {
            this.setEnableSubPanels(true);
        } else {
            this.setEnableSubPanels(false);
        }
        return true;
    }

    private void setEnableSubPanels(boolean value) {
        this.toolModePanel.setEnabled(value);
        this.toolCommInfoPanel.setEnabled(value);
    }

    private void enterSubPanels() {
        this.toolModePanel.enter();
        this.toolCommInfoPanel.enter();
    }

    private void exitSubPanels() {
        this.toolModePanel.exit();
        this.toolCommInfoPanel.exit();
    }

    private void initHelpIds(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId((JComponent)this.controlCombobox, "gui:installation_Tool_Interface_Control_Panel");
    }

    void fireInstallationChangedEvent() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
    }

    private void subscribeToolIOControlServiceListener() {
        this.toolIOControlServiceSubscription = this.eventManager.addStrongListener(ToolIOControlServiceListener.class, (Object)this);
    }

    private void unsubscribeToolIOControlServiceListener() {
        if (this.toolIOControlServiceSubscription == null) {
            return;
        }
        this.toolIOControlServiceSubscription.dispose();
        this.toolIOControlServiceSubscription = null;
    }

    public DefaultComboBoxModel getContollerComboBoxModel() {
        ControllerComboBoxModel model = new ControllerComboBoxModel();
        this.setControlomboBoxModel(model);
        return model;
    }

    private class ControllerComboBoxModel
    extends DefaultComboBoxModel {
        private ControllerComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof ResourceControllerHeading) {
                return;
            }
            super.setSelectedItem(anObject);
        }
    }
}

