/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.view;

import com.ur.polyscope.io.impl.tool.view.ResourceControllerHeading;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.UIManager;

public class ToolIOControlRender
extends DefaultComboBoxRenderer {
    private static final Color HEADER_FOREGROUND = UIManager.getColor("DropDownHeaderForeground");
    private static final Color HEADER_BACKGROUND = UIManager.getColor("DropDownHeaderBackground");
    private static final int HEADER_FONT_SIZE = UIManager.getInt("DropDownHeaderFontSize");
    private static final Color UNDEFINED_WARNING = UIManager.getColor("undefined.warning");
    private static final Color SELECTED_BACKGROUND = UIManager.getColor("ComboBox.selectionBackground");
    private static final Color DEFAULT_BACKGROUND = UIManager.getColor("ComboBox.background");
    private final RenderingStrategy renderingStrategy;

    public ToolIOControlRender(RenderingStrategy renderingStrategy) {
        this.renderingStrategy = renderingStrategy;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setOpaque(true);
        this.setText(this.renderingStrategy.getText(value));
        this.setIcon(this.renderingStrategy.getIcon(value));
        if (value instanceof ResourceControllerHeading) {
            ResourceControllerHeading controllerHeading = (ResourceControllerHeading)value;
            this.renderControllerTitle(list, controllerHeading);
            return this;
        }
        if (this.renderingStrategy.hasError(value) && this.countItemsIn(list) > 0) {
            this.setFont(this.getFont().deriveFont(2));
            this.setBackground(UNDEFINED_WARNING);
        } else if (isSelected) {
            this.setBackground(SELECTED_BACKGROUND);
        } else {
            this.setFont(this.getFont().deriveFont(0));
            this.setBackground(DEFAULT_BACKGROUND);
        }
        return this;
    }

    private int countItemsIn(JList list) {
        return list.getModel().getSize();
    }

    private void renderControllerTitle(JList list, ResourceControllerHeading heading) {
        this.setFont(new Font(list.getFont().getFontName(), 1, HEADER_FONT_SIZE));
        this.setText(heading.getDisplayName());
        this.setBackground(HEADER_BACKGROUND);
        this.setForeground(HEADER_FOREGROUND);
    }
}

