/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.view;

import com.ur.lang.StringUtils;
import com.ur.polyscope.io.impl.tool.ToolCommInfoPresenter;
import com.ur.polyscope.io.impl.tool.ToolModePresenter;
import com.ur.polyscope.io.impl.tool.view.ToolCommInfoPanel;
import com.ur.polyscope.io.impl.tool.view.ToolModePanel;
import com.ur.polyscope.io.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ToolIOSwingView
extends CardPanel {
    public static final String SHOW_TOOL_ACTION = "showToolAction.ToolIOSwingView";
    public static final String SELECT_ANALOG_INPUTS = "analogInputs.ToolIOSwingView";
    public static final String SELECT_COMMUNICATION_INTERFACE = "enableButton.ToolIOSwingView";
    public static final String DISABLE_BUTTON = "disableButton.ToolIOSwingView";
    public static final String BAUD_RATE_COMBO_BOX = "baudRateComboBox.ToolIOSwingView";
    public static final String PARITY_COMBO_BOX = "parityComboBox.ToolIOSwingView";
    public static final String STOP_BITS_COMBO_BOX = "stopBitsComboBox.ToolIOSwingView";
    public static final String STOP_BITS_ONE = "stopBitsOne.ToolIOSwingView";
    public static final String STOP_BITS_TWO = "stopBitsTwo.ToolIOSwingView";
    public static final String TX_IDLE_CHARS_NUMBER_FIELD = "txIdleCharsNumberField.ToolIOSwingView";
    public static final String RX_IDLE_CHARS_NUMBER_FIELD = "rxIdleCharsNumberField.ToolIOSwingView";
    public static final String DIGITAL_0_MODE = "digital0mode.ToolIOSwingView";
    public static final String DIGITAL_1_MODE = "digital1mode.ToolIOSwingView";
    public static final String STANDARD_OUTPUT_MODE = "outputmode.ToolIOSwingView";
    public static final String POWER_MODE = "powermode.ToolIOSwingView";
    protected final ToolCommInfoPanel toolCommInfoPanel;
    protected final ToolModePanel toolModePanel;

    @Inject
    ToolIOSwingView(ToolCommInfoPresenter toolCommInfoPresenter, ToolModePresenter toolModePresenter, HelpIdAssigner helpIdAssigner, ViewContext viewContext) {
        this(toolCommInfoPresenter, toolModePresenter, helpIdAssigner, viewContext, true);
    }

    ToolIOSwingView(ToolCommInfoPresenter toolCommInfoPresenter, ToolModePresenter toolModePresenter, HelpIdAssigner helpIdAssigner, ViewContext viewContext, boolean setLayout) {
        this.toolModePanel = new ToolModePanel(toolModePresenter, viewContext, helpIdAssigner);
        this.toolCommInfoPanel = new ToolCommInfoPanel(toolCommInfoPresenter, helpIdAssigner, viewContext);
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        if (setLayout) {
            TextResource text = (TextResource)viewContext.getTextResource(TextResource.class);
            this.setLayout(text);
        }
    }

    protected void setLayout(TextResource text) {
        this.setLayout(new GridLayout(1, 2, 5, 5));
        this.add(this.addCardBorder(text.toolComm(), this.toolCommInfoPanel));
        this.add(this.addCardBorder(text.toolMode(), this.toolModePanel));
    }

    protected JPanel addCardBorder(String title, JPanel panel) {
        Border innerBorder = panel.getBorder();
        if (StringUtils.isNullOrOnlyWhitespace((String)title)) {
            panel.setBorder(innerBorder);
        } else {
            panel.setBorder(new CompoundBorder((Border)new CardBorder(title), innerBorder));
        }
        return panel;
    }

    public void enter(Object o) {
        super.enter(o);
        this.toolCommInfoPanel.enter();
        this.toolModePanel.enter();
    }

    public Object exit() {
        this.toolCommInfoPanel.exit();
        this.toolModePanel.exit();
        return super.exit();
    }
}

