/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.view;

import com.ur.polyscope.io.impl.tool.ToolModePresenter;
import com.ur.polyscope.io.impl.tool.ToolModeView;
import com.ur.polyscope.io.impl.tool.ToolModeViewModel;
import com.ur.polyscope.io.internal.ImageResource;
import com.ur.polyscope.io.internal.TextResource;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.swing.EnumComboBoxModel;
import com.ur.swing.EnumListCellRenderer;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.view.constants.dev.ToolDigitalOutputMode;
import com.ur.view.constants.dev.ToolOutputMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ToolModePanel
extends JPanel
implements ToolModeView {
    private static final int RADIO_BUTTON_WIDTH = 36;
    private static final String TOOL_MODE_PANEL_TOOL_IOSWING_VIEW = "ToolModePanel.ToolIOSwingView";
    private JComboBox digital0Mode;
    private JComboBox digital1Mode;
    private JRadioButton standardMode;
    private JRadioButton powerMode;
    private JComboBox toolVoltage;
    private ButtonGroup outputModeGroup;
    private HashMap<String, ToolOutputMode> outputModes;
    private ToolModePresenter toolModePresenter;
    private ViewContext viewContext;
    private boolean isUpdatingCard;

    ToolModePanel(ToolModePresenter presenter, ViewContext viewContext, HelpIdAssigner helpIdAssigner) {
        this.toolModePresenter = presenter;
        this.viewContext = viewContext;
        this.setName(TOOL_MODE_PANEL_TOOL_IOSWING_VIEW);
        this.initializeOutputModes();
        this.initComponents();
        this.setPanelLayout();
        this.initHelpIds(helpIdAssigner);
        presenter.setView(this);
    }

    public void enter() {
        this.toolModePresenter.modelUpdated();
        this.toolModePresenter.startBackgroundService();
    }

    public void exit() {
        this.toolModePresenter.stopBackgroundService();
    }

    @Override
    public void initializeView(ToolModePresenter.ToolModeViewInitializer initializer) {
        this.digital0Mode.setRenderer(new EnumListCellRenderer(initializer.toolDigitalOutputModes));
        this.digital1Mode.setRenderer(new EnumListCellRenderer(initializer.toolDigitalOutputModes));
    }

    @Override
    public void updateView(ToolModeViewModel toolModeViewModel) {
        this.isUpdatingCard = true;
        this.outputModeGroup.setSelected(this.standardMode.getModel(), toolModeViewModel.outputMode == ToolOutputMode.OUTPUT);
        this.outputModeGroup.setSelected(this.powerMode.getModel(), toolModeViewModel.outputMode == ToolOutputMode.POWER);
        this.digital0Mode.setSelectedItem(toolModeViewModel.pin0Mode);
        this.digital1Mode.setSelectedItem(toolModeViewModel.pin1Mode);
        this.toolVoltage.setSelectedItem(toolModeViewModel.toolOutputVoltage);
        this.updateDigitalModes();
        this.isUpdatingCard = false;
    }

    private void initializeOutputModes() {
        this.outputModes = new HashMap();
        this.outputModes.put("outputmode.ToolIOSwingView", ToolOutputMode.OUTPUT);
        this.outputModes.put("powermode.ToolIOSwingView", ToolOutputMode.POWER);
    }

    private void initComponents() {
        this.toolVoltage = new JComboBox<Voltage>(Voltage.values());
        this.toolVoltage.addActionListener(new ToolDigitalModeChanged());
        this.standardMode = new JRadioButton(((TextResource)this.viewContext.getTextResource(TextResource.class)).outputMode());
        this.standardMode.setName("outputmode.ToolIOSwingView");
        this.standardMode.setActionCommand("outputmode.ToolIOSwingView");
        this.standardMode.addActionListener(new ToolOutputModeChanged());
        this.digital0Mode = new JComboBox(new EnumComboBoxModel(ToolDigitalOutputMode.class, (Enum[])new ToolDigitalOutputMode[]{ToolDigitalOutputMode.DISABLED}));
        this.digital0Mode.setName("digital0mode.ToolIOSwingView");
        this.digital0Mode.addActionListener(new ToolDigitalModeChanged());
        this.digital1Mode = new JComboBox(new EnumComboBoxModel(ToolDigitalOutputMode.class, (Enum[])new ToolDigitalOutputMode[]{ToolDigitalOutputMode.DISABLED}));
        this.digital1Mode.setName("digital1mode.ToolIOSwingView");
        this.digital1Mode.addActionListener(new ToolDigitalModeChanged());
        this.powerMode = new JRadioButton(((TextResource)this.viewContext.getTextResource(TextResource.class)).powerMode());
        this.powerMode.setName("powermode.ToolIOSwingView");
        this.powerMode.setActionCommand("powermode.ToolIOSwingView");
        this.powerMode.addActionListener(new ToolOutputModeChanged());
        this.outputModeGroup = new ButtonGroup();
        this.outputModeGroup.add(this.standardMode);
        this.outputModeGroup.add(this.powerMode);
    }

    private void setPanelLayout() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        JComponent separator = this.viewContext.createWidgetFactory().createSeparator(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.viewContext.createFormBuilder().description(textResource.toolModeInstallDetails(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).label(textResource.toolOutputVoltage(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.toolVoltage, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end().label(ImageResource.formWarning(), textResource.toolModeInstallWarning(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).end().component(separator, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.powerMode, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).spacer().end().end().component((JComponent)this.standardMode, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).spacer().end().component(this.indentRadioButtonSize(textResource.toolOutputMode(0)), new FormBuilder.PanelConstraints[0]).component((JComponent)this.digital0Mode, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end().component(this.indentRadioButtonSize(textResource.toolOutputMode(1)), new FormBuilder.PanelConstraints[0]).component((JComponent)this.digital1Mode, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end().setOnPanel((JPanel)this);
    }

    private JComponent indentRadioButtonSize(String text) {
        return this.indentRadioButtonSize(new JLabel(text));
    }

    private JComponent indentRadioButtonSize(JLabel label) {
        Box result = Box.createHorizontalBox();
        result.add(Box.createHorizontalStrut(36));
        result.add(label);
        return result;
    }

    private void initHelpIds(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId((JComponent)this, "gui:installation_Tool_Mode_Panel");
    }

    private ToolOutputMode getSelectedOutputMode() {
        return this.outputModes.get(this.outputModeGroup.getSelection().getActionCommand());
    }

    private void updateDigitalModes() {
        boolean isOutputMode;
        boolean bl = isOutputMode = this.getSelectedOutputMode() == ToolOutputMode.OUTPUT;
        if (!this.isEnabled()) {
            return;
        }
        this.digital0Mode.setEnabled(isOutputMode);
        this.digital1Mode.setEnabled(isOutputMode);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.digital0Mode.setEnabled(enabled);
        this.digital1Mode.setEnabled(enabled);
        this.standardMode.setEnabled(enabled);
        this.powerMode.setEnabled(enabled);
        this.toolVoltage.setEnabled(enabled);
    }

    private class ToolDigitalModeChanged
    implements ActionListener {
        private ToolDigitalModeChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolModePanel.this.isUpdatingCard) {
                return;
            }
            ToolModePanel.this.toolModePresenter.viewStateChanged(new ToolModeViewModel(ToolModePanel.this.getSelectedOutputMode(), (ToolDigitalOutputMode)ToolModePanel.this.digital0Mode.getSelectedItem(), (ToolDigitalOutputMode)ToolModePanel.this.digital1Mode.getSelectedItem(), (Voltage)ToolModePanel.this.toolVoltage.getSelectedItem()));
        }
    }

    private class ToolOutputModeChanged
    implements ActionListener {
        private ToolOutputModeChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolModePanel.this.isUpdatingCard) {
                return;
            }
            ToolModePanel.this.updateDigitalModes();
            ToolModePanel.this.toolModePresenter.outputStateChanged(new ToolModeViewModel(ToolModePanel.this.getSelectedOutputMode(), (ToolDigitalOutputMode)ToolModePanel.this.digital0Mode.getSelectedItem(), (ToolDigitalOutputMode)ToolModePanel.this.digital1Mode.getSelectedItem(), (Voltage)ToolModePanel.this.toolVoltage.getSelectedItem()));
        }
    }
}

