/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.util;

import com.ur.disk.Directories;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;

public final class ControllerInterfaceSettings {
    private static final int DEFAULT_PORT = 30001;
    private static final String DEFAULT_CONTROLLER_IP = "127.0.0.1";
    private static final String DEFAULT_CONTROLLER_IP_DOCKER = "172.17.0.1";
    private static final String SERVER_IP_KEY = "ip";
    private static final String SERVER_PORT_KEY = "port";
    private static final String CONTROLLER_SOCKET_IP = "controller.socket.ip";
    private static final String CONTROLLER_SOCKET_PORT = "controller.socket.port";
    private static final String RUNNING_IN_DEVELOPMENT_MODE = "RunningInDevelopmentMode";
    private static final WriteableModuleSettings moduleSettings = new WriteableModuleSettings("controllerinterface.properties");
    private static final WriteableModuleSettings polyscopeSettings = new WriteableModuleSettings("gui.properties");
    private static final String REALTIME_DATA_SECONDS = "realtimeDataSeconds";
    private static final String SERVER_CONFIG_FILE = "/server.conf";
    private static final String DOCKER_ENV_FILE = "/.dockerenv";

    private ControllerInterfaceSettings() {
    }

    public static String getControllerSocketIp() {
        String defaultIp = DEFAULT_CONTROLLER_IP;
        if (Paths.get(DOCKER_ENV_FILE, new String[0]).toFile().exists()) {
            File configFile = new File(Directories.urcontrol().getPath() + SERVER_CONFIG_FILE);
            Properties properties = new Properties();
            if (configFile.exists() && configFile.canRead()) {
                try (FileInputStream inputStream = new FileInputStream(configFile);){
                    properties.load(inputStream);
                    defaultIp = properties.getProperty(SERVER_IP_KEY, DEFAULT_CONTROLLER_IP_DOCKER);
                }
                catch (IOException e) {
                    Log.error((String)"An error occurred while reading the server config file.", (Throwable)e);
                }
            } else {
                Log.error((String)"Cannot read file. Check if the file exists and you have permission to read it.");
            }
        }
        return moduleSettings.properties().getProperty(CONTROLLER_SOCKET_IP, defaultIp);
    }

    public static int getControllerPort() {
        int defaultPort = 30001;
        if (Paths.get(DOCKER_ENV_FILE, new String[0]).toFile().exists()) {
            File configFile = new File(Directories.urcontrol().getPath() + SERVER_CONFIG_FILE);
            Properties properties = new Properties();
            if (configFile.exists() && configFile.canRead()) {
                try (FileInputStream inputStream = new FileInputStream(configFile);){
                    properties.load(inputStream);
                    defaultPort = Integer.parseInt(properties.getProperty(SERVER_PORT_KEY, "30001"));
                }
                catch (IOException e) {
                    Log.error((String)"An error occurred while reading the server config file.", (Throwable)e);
                }
            } else {
                Log.error((String)"Cannot read file. Check if the file exists and you have permission to read it.");
            }
        }
        return moduleSettings.properties().getInteger(CONTROLLER_SOCKET_PORT, defaultPort);
    }

    public static boolean isRunningInDevelopmentMode() {
        return polyscopeSettings.properties().getBoolean(RUNNING_IN_DEVELOPMENT_MODE, false);
    }

    public static int getFlightRecorderWindowSizeInSeconds() {
        return polyscopeSettings.properties().getInteger(REALTIME_DATA_SECONDS, 30);
    }
}

