/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.swing.driver;

import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.screwdriving.swing.driver.AbstractScrewdrivingDriver;
import com.ur.polyscope.screwdriving.swing.driver.ExpressionEditorDriver;
import com.ur.polyscope.screwdriving.swing.driver.ScrewdrivingNames;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class ScrewdrivingHandlerDriver
extends AbstractScrewdrivingDriver {
    private ScrewdrivingNames screwdrivingNames;

    @Inject
    protected ScrewdrivingHandlerDriver(MainScreen mainScreen, String driverShowingComponentName, ScrewdrivingNames screwdrivingNames) {
        super(mainScreen, driverShowingComponentName);
        this.screwdrivingNames = screwdrivingNames;
    }

    public void navigateToFirstUndefinedHandler() {
        this.navigateToTreeNode(this.screwdrivingNames.getUndefinedUntilName());
    }

    public void navigateToHandlerNode(HandlerType handlerType) {
        String treeName = this.screwdrivingNames.getHandlerTreeName(handlerType);
        this.navigateToTreeNode(treeName);
    }

    public void selectHandlerFromUndefined(HandlerType handlerType) {
        String buttonName;
        switch (handlerType) {
            case UNTIL_OK: {
                buttonName = "ScrewdrivingHandlersNodeView.okButton";
                break;
            }
            case UNTIL_TIME: {
                buttonName = "ScrewdrivingHandlersNodeView.timeButton";
                break;
            }
            case UNTIL_DISTANCE: {
                buttonName = "ScrewdrivingHandlersNodeView.distanceButton";
                break;
            }
            case UNTIL_EXPRESSION: {
                buttonName = "ScrewdrivingHandlersNodeView.expressionButton";
                break;
            }
            case ERROR_NOK: {
                buttonName = "ScrewdrivingHandlersNodeView.notOkButton";
                break;
            }
            case ERROR_TIMEOUT: {
                buttonName = "ScrewdrivingHandlersNodeView.timeoutButton";
                break;
            }
            case ERROR_DISTANCE: {
                buttonName = "ScrewdrivingHandlersNodeView.errorDistanceButton";
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)handlerType) + " unknown");
            }
        }
        AbstractButtonOperator buttonOperator = this.buttonNamed(buttonName);
        Waiting.until(() -> buttonOperator.isShowing() && buttonOperator.isEnabled(), (int)2, (TimeUnit)TimeUnit.SECONDS);
        if (!buttonOperator.isEnabled()) {
            throw new IllegalArgumentException("Button for " + (Object)((Object)handlerType) + " not enabled");
        }
        this.push(buttonOperator);
    }

    public void selectHandlerFromDropDown(HandlerType handlerType) {
        boolean selected;
        String comboBoxName = "ScrewdrivingHandlersNodeView.handlerDropdown";
        boolean isShowing = Waiting.until(() -> this.comboBoxNamed(comboBoxName).isShowing(), (int)3, (TimeUnit)TimeUnit.SECONDS);
        if (!isShowing) {
            throw new IllegalStateException("Handler dropdown not shown for handlerType " + (Object)((Object)handlerType));
        }
        JComboBoxOperator operator = this.inComboBox(comboBoxName);
        String handlerName = this.screwdrivingNames.getHandlerDropDownName(handlerType);
        for (int i = 0; i < operator.getItemCount(); ++i) {
            String item;
            Object comboboxItem = operator.getItemAt(i);
            if (comboboxItem == null || !(item = comboboxItem.toString()).equals(handlerName)) continue;
            operator.setSelectedIndex(i);
            break;
        }
        if (!(selected = Waiting.until(() -> this.comboBoxNamed(comboBoxName).getSelectedItem().toString().equals(handlerName), (int)10, (TimeUnit)TimeUnit.SECONDS))) {
            throw new IllegalStateException("Could not select " + handlerName);
        }
    }

    public void setTime(double time) {
        JTextFieldOperator field = this.textFieldNamed("ScrewdrivingHandlersNodeView.timeInput");
        ScrewdrivingHandlerDriver.enterNumber(time, field);
    }

    public double getTime() {
        JTextFieldOperator field = this.textFieldNamed("ScrewdrivingHandlersNodeView.timeInput");
        return Double.valueOf(field.getText());
    }

    public void setDistance(double distance) {
        JTextFieldOperator field = this.textFieldNamed("ScrewdrivingHandlersNodeView.distanceInput");
        ScrewdrivingHandlerDriver.enterNumber(distance, field);
    }

    public void setErrorDistance(double distance) {
        JTextFieldOperator field = this.textFieldNamed("ScrewdrivingHandlersNodeView.errorDistanceInput");
        ScrewdrivingHandlerDriver.enterNumber(distance, field);
    }

    public double getErrorDistance() {
        JTextFieldOperator field = this.textFieldNamed("ScrewdrivingHandlersNodeView.errorDistanceInput");
        return Double.valueOf(field.getText());
    }

    public String getExpression() {
        JTextFieldOperator field = this.textFieldNamed("ScrewdrivingHandlersNodeView.expressionInput");
        return field.getText();
    }

    private static void enterNumber(double value, JTextFieldOperator field) {
        NumberKeyPadOperator op = new NumberKeyPadOperator(field);
        op.punchInKeypad(Double.toString(value));
        op.clickOk();
    }

    public ExpressionEditorDriver openExpressionEditor() {
        this.textFieldNamed("ScrewdrivingHandlersNodeView.expressionInput").clickMouse();
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        return new ExpressionEditorDriver(this.mainScreen);
    }

    public static enum HandlerType {
        UNTIL_OK,
        UNTIL_TIME,
        UNTIL_DISTANCE,
        UNTIL_EXPRESSION,
        ERROR_NOK,
        ERROR_TIMEOUT,
        ERROR_DISTANCE;

    }
}

