/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.swing.driver;

import com.ur.polyscope.application.driver.conceptoperations.LoadMenuDriver;
import com.ur.polyscope.application.driver.conceptoperations.OpenFileDialogDriver;
import com.ur.polyscope.application.driver.conceptoperations.SaveMenuDriver;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.Dialog;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;

public class ScrewdrivingInstallationDriver
extends BaseDriver {
    private static final String TCP_COMBOBOX = "ScrewdrivingInstallationNodeView.selectTCP";
    private static final String OK_COMBOBOX = "ScrewdrivingInstallationNodeView.selectOK";
    private static final String NOK_COMBOBOX = "ScrewdrivingInstallationNodeView.selectNOK";
    private static final String READY_COMBOBOX = "ScrewdrivingInstallationNodeView.selectReady";
    private static final String PROGRAM_1_COMBOBOX = "ScrewdrivingInstallationNodeView.selectProgram1";
    private static final String PROGRAM_2_COMBOBOX = "ScrewdrivingInstallationNodeView.selectProgram2";
    private static final String PROGRAM_3_COMBOBOX = "ScrewdrivingInstallationNodeView.selectProgram3";
    private static final String PROGRAM_4_COMBOBOX = "ScrewdrivingInstallationNodeView.selectProgram4";
    private static final String START_COMBOBOX = "ScrewdrivingInstallationNodeView.selectStart";
    private static final String SIMPSONS_COMBOBOX = "ScrewdrivingInstallationNodeView.selectDriver";
    private static final String CONFIRM_BUTTON = "confirm.confirmMessageDialog";
    private final LoadMenuDriver loadMenuDriver;
    private final SaveMenuDriver saveMenuDriver;
    private final DialogRegistry dialogRegistry;

    @Inject
    ScrewdrivingInstallationDriver(MainScreen mainScreen, LoadMenuDriver loadMenuDriver, SaveMenuDriver saveMenuDriver, DialogRegistry dialogRegistry) {
        super(mainScreen, "Screwdriving");
        this.loadMenuDriver = loadMenuDriver;
        this.saveMenuDriver = saveMenuDriver;
        this.dialogRegistry = dialogRegistry;
    }

    public void loadInstallation(String fileName) {
        this.loadMenuDriver.press();
        Waiting.until(() -> this.isShowing("fileManager.open.FileManagerButtonFactory.popup"), (int)2, (TimeUnit)TimeUnit.SECONDS);
        OpenFileDialogDriver fileDialog = this.loadMenuDriver.loadInstallation();
        if (this.dialogRegistry.isDialogShown((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES)) {
            this.dialogRegistry.inDialog((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES).pushButton(CONFIRM_BUTTON);
        }
        Waiting.until(() -> !fileDialog.isNotShowing(), (int)3, (TimeUnit)TimeUnit.SECONDS);
        fileDialog.selectFile(fileName);
        fileDialog.openFile();
        if (this.dialogRegistry.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION)) {
            this.dialogRegistry.inDialog((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION).pushButton(CONFIRM_BUTTON);
        }
        if (this.dialogRegistry.isDialogShown((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM)) {
            this.dialogRegistry.inDialog((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM).pushButton(CONFIRM_BUTTON);
        }
        Waiting.until(() -> !this.dialogRegistry.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION), (int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public void saveInstallation(String fileName) {
        this.saveMenuDriver.press();
        OpenFileDialogDriver fileDialog = this.saveMenuDriver.saveInstallation();
        Waiting.until(() -> !fileDialog.isNotShowing(), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TextPickerOperator textField = fileDialog.clearAndType(fileName);
        textField.clickOkToClose();
        if (this.dialogRegistry.isDialogShown((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM)) {
            this.dialogRegistry.inDialog((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM).pushButton(CONFIRM_BUTTON);
        }
    }

    public void selectScrewdrivingNode() {
        this.push(this.buttonNamed("com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeService"));
    }

    public void setTCP(String tcpName) {
        this.setValueInComboBox(tcpName, TCP_COMBOBOX);
    }

    public void setOKSignal(String ioName) {
        this.setValueInComboBox(ioName, OK_COMBOBOX);
    }

    public void setNOKSignal(String ioName) {
        this.setValueInComboBox(ioName, NOK_COMBOBOX);
    }

    public void setReadySignal(String ioName) {
        this.setValueInComboBox(ioName, READY_COMBOBOX);
    }

    public void setProgram(String ioName, int index) {
        String comboBoxName = ScrewdrivingInstallationDriver.getProgramComboBox(index);
        if (comboBoxName != null) {
            this.setValueInComboBox(ioName, comboBoxName);
        }
    }

    public void setStartSignal(String ionName) {
        this.setValueInComboBox(ionName, START_COMBOBOX);
    }

    public void setDriver(String driverName) {
        this.setValueInComboBox(driverName, SIMPSONS_COMBOBOX);
    }

    public String getSelectedTCP() {
        return this.getSelectedItemFromComboBox(TCP_COMBOBOX);
    }

    public String getSelectedOKSignal() {
        return this.getSelectedItemFromComboBox(OK_COMBOBOX);
    }

    public String getSelectedNOKSignal() {
        return this.getSelectedItemFromComboBox(NOK_COMBOBOX);
    }

    public String getSelectedReadySignal() {
        return this.getSelectedItemFromComboBox(READY_COMBOBOX);
    }

    public String getSelectedProgramSignal(int index) {
        String comboBoxName = ScrewdrivingInstallationDriver.getProgramComboBox(index);
        return comboBoxName != null ? this.getSelectedItemFromComboBox(comboBoxName) : null;
    }

    public String getSelectedStartSignal() {
        return this.getSelectedItemFromComboBox(START_COMBOBOX);
    }

    public boolean uiElementExists(String id) {
        JComponentOperator component = this.componentNamed(id + ".InstallationNodeView");
        return component != null;
    }

    private static String getProgramComboBox(int index) {
        String comboBoxName;
        switch (index) {
            case 1: {
                comboBoxName = PROGRAM_1_COMBOBOX;
                break;
            }
            case 2: {
                comboBoxName = PROGRAM_2_COMBOBOX;
                break;
            }
            case 3: {
                comboBoxName = PROGRAM_3_COMBOBOX;
                break;
            }
            case 4: {
                comboBoxName = PROGRAM_4_COMBOBOX;
                break;
            }
            default: {
                comboBoxName = null;
            }
        }
        return comboBoxName;
    }

    public void setValueInComboBox(String value, String comboBoxName) {
        boolean selected;
        JComboBoxOperator comboBoxOperator = this.inComboBox(comboBoxName);
        for (int i = 0; i < comboBoxOperator.getItemCount(); ++i) {
            String item;
            Object comboboxItem = comboBoxOperator.getItemAt(i);
            if (comboboxItem == null || !(item = comboboxItem.toString()).equals(value)) continue;
            comboBoxOperator.setSelectedIndex(i);
            break;
        }
        if (!(selected = Waiting.until(() -> {
            Object selectedItem = this.comboBoxNamed(comboBoxName).getSelectedItem();
            return selectedItem != null && selectedItem.toString().equals(value);
        }, (int)10, (TimeUnit)TimeUnit.SECONDS))) {
            throw new IllegalStateException("Unable to select " + value + " in ComboBox " + comboBoxName);
        }
    }

    private String getSelectedItemFromComboBox(String comboBoxName) {
        return this.comboBoxNamed(comboBoxName).getSelectedItem().toString();
    }
}

