/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.swing.driver;

import com.ur.polyscope.application.driver.conceptoperations.LoadMenuDriver;
import com.ur.polyscope.application.driver.conceptoperations.OpenFileDialogDriver;
import com.ur.polyscope.application.driver.conceptoperations.SaveMenuDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.program.ProgramScreenDriver;
import com.ur.polyscope.driver.api.program.ProgramSectionName;
import com.ur.polyscope.screwdriving.swing.driver.AbstractScrewdrivingDriver;
import com.ur.polyscope.screwdriving.swing.driver.ScrewdrivingNames;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import com.ur.util.Waiting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;

public class ScrewdrivingProgramDriver
extends AbstractScrewdrivingDriver {
    private final ScrewdrivingNames screwdrivingNames;
    private final ProgramScreenDriver programScreenDriver;
    private final LoadMenuDriver loadMenuDriver;
    private final SaveMenuDriver saveMenuDriver;

    @Inject
    protected ScrewdrivingProgramDriver(MainScreen mainScreen, ScrewdrivingNames screwdrivingNames, ProgramScreenDriver programScreenDriver, LoadMenuDriver loadMenuDriver, SaveMenuDriver saveMenuDriver) {
        super(mainScreen, screwdrivingNames.getProgramNodeTitle());
        this.screwdrivingNames = screwdrivingNames;
        this.programScreenDriver = programScreenDriver;
        this.loadMenuDriver = loadMenuDriver;
        this.saveMenuDriver = saveMenuDriver;
    }

    public void addScrewdrivingNode() {
        this.programScreenDriver.select();
        this.programScreenDriver.selectSection(ProgramSectionName.TEMPLATES);
        this.push(this.buttonNamed("wizardNodesSection.ProgramTab." + this.screwdrivingNames.getProgramNodeTitle()));
    }

    public void selectScrewdrivingNode() {
        this.navigateToTreeNode(this.screwdrivingNames.getProgramNodeTitle());
    }

    public List<ScrewdriverProgram> getAvailablePrograms() {
        JComboBoxOperator dropdown = this.getProgramsDropdown();
        ArrayList<ScrewdriverProgram> items = new ArrayList<ScrewdriverProgram>();
        for (int i = 0; i < dropdown.getItemCount(); ++i) {
            items.add((ScrewdriverProgram)dropdown.getItemAt(i));
        }
        return items;
    }

    public void selectProgram(ScrewdriverProgram selection) {
        List<ScrewdriverProgram> availablePrograms = this.getAvailablePrograms();
        Optional<ScrewdriverProgram> program = availablePrograms.stream().filter(screwdriverProgram -> screwdriverProgram == selection).findFirst();
        if (!program.isPresent()) {
            throw new IllegalArgumentException("Program '" + selection + "' not found");
        }
        JComboBoxOperator programsDropdown = this.getProgramsDropdown();
        for (int i = 0; i < programsDropdown.getItemCount(); ++i) {
            ScrewdriverProgram currentProgram = (ScrewdriverProgram)programsDropdown.getItemAt(i);
            if (!currentProgram.getId().equals(selection.getId())) continue;
            programsDropdown.setSelectedIndex(i);
        }
        ScrewdriverProgram selectedItem = (ScrewdriverProgram)programsDropdown.getSelectedItem();
        if (selectedItem == null) {
            throw new IllegalStateException("Unable to select " + selection.getDisplayName() + " in programs dropdown");
        }
    }

    public String getSelectedProgram() {
        return this.getProgramsDropdown().getSelectedItem().toString();
    }

    public void addHandler() {
        this.push(this.buttonNamed("ScrewdrivingProgramNodeView.addHandler"));
    }

    public void toggleFollowScrew() {
        this.push((AbstractButtonOperator)this.checkBoxNamed("ScrewdrivingProgramNodeView.followScrew"));
    }

    public void toggleMachineErrorHandler() {
        this.push((AbstractButtonOperator)this.checkBoxNamed("ScrewdrivingProgramNodeView.addMachineErrorHandler"));
    }

    public void saveProgram(String filename) {
        this.saveMenuDriver.press();
        OpenFileDialogDriver saveFileDialog = this.saveMenuDriver.saveProgram();
        Waiting.until(() -> !saveFileDialog.isNotShowing(), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TextPickerOperator textField = saveFileDialog.clearAndType(filename);
        textField.clickOkToClose();
    }

    public void loadProgram(String filename) {
        this.loadMenuDriver.press();
        Waiting.until(() -> this.isShowing("fileManager.open.FileManagerButtonFactory.popup"), (int)2, (TimeUnit)TimeUnit.SECONDS);
        OpenFileDialogDriver openFileDialog = this.loadMenuDriver.loadProgram();
        Waiting.until(() -> !openFileDialog.isNotShowing(), (int)2, (TimeUnit)TimeUnit.SECONDS);
        openFileDialog.selectFile(filename);
        openFileDialog.openFile();
        this.programScreenDriver.select();
        Waiting.until(() -> this.treeHasNode(this.screwdrivingNames.getProgramNodeTitle()), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    private JComboBoxOperator getProgramsDropdown() {
        return this.comboBoxNamed("ScrewdrivingProgramNodeView.programSelect");
    }
}

