/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.appearance.impl;

import com.ur.polyscope.visualizer.appearance.impl.AbstractRobotAppearance;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class GrayRobotAppearance
extends AbstractRobotAppearance {
    Color3f ambientLightColor = new Color3f(0.8f, 0.8f, 1.0f);
    Color3f directionalLightColor = new Color3f(0.0f, 0.0f, 0.0f);

    GrayRobotAppearance() {
        Color3f ambientColor = new Color3f(0.4f, 0.4f, 0.4f);
        Color3f emissiveColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f diffuseColor = new Color3f(0.6f, 0.6f, 0.6f);
        Color3f specularColor = new Color3f(0.2f, 0.2f, 0.2f);
        float shininess = 0.3f;
        Material metalMaterial = new Material(ambientColor, emissiveColor, diffuseColor, specularColor, shininess);
        Material shadowMaterial = new Material(new Color3f(0.4f, 0.4f, 0.4f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.6f, 0.6f, 0.6f), new Color3f(0.2f, 0.2f, 0.2f), 0.3f);
        this.metalApp.setMaterial(metalMaterial);
        this.bluePlasticApp.setMaterial(metalMaterial);
        this.floorApp.setMaterial(metalMaterial);
        this.shadowApp.setMaterial(shadowMaterial);
        this.shadowApp.setTransparencyAttributes(new TransparencyAttributes(0, 0.85f));
    }

    public void addLights(TransformGroup tg) {
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 5000.0);
        AmbientLight aLgt = new AmbientLight(this.ambientLightColor);
        aLgt.setInfluencingBounds((Bounds)bounds);
        tg.addChild((Node)aLgt);
        Vector3f lDir1 = new Vector3f(0.5f, -0.9f, -0.8f);
        DirectionalLight lgt1 = new DirectionalLight(this.directionalLightColor, lDir1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        tg.addChild((Node)lgt1);
    }
}

