/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.appearance.impl;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.polyscope.robot.configuration.visualization.VisualizationProvider;
import com.ur.polyscope.robot.configuration.visualization.VisualizationType;
import com.ur.polyscope.visualizer.appearance.impl.AbstractRobotAppearance;
import java.util.BitSet;
import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.media.j3d.TransformGroup;

public class Robot3D
extends BranchGroup {
    private JointPositionVector.LinkTransform[] link = new JointPositionVector.LinkTransform[6];
    private VisualizationType visualizationType;
    private boolean hasBeenDrawn = false;
    private AbstractRobotAppearance robotAppearance;
    private BitSet VISIBLE = new BitSet(){
        {
            this.set(0);
        }
    };
    private BitSet HIDDEN = new BitSet(){
        {
            this.set(1);
        }
    };
    private Switch visibilitySwitch;
    private final VisualizationProvider visualizationProvider;

    public Robot3D(AbstractRobotAppearance newRobotAppearance, VisualizationType visualizationType, VisualizationProvider visualizationProvider) {
        this.visualizationProvider = visualizationProvider;
        this.setCapability(13);
        this.robotAppearance = newRobotAppearance;
        this.visualizationType = visualizationType;
    }

    public void drawRobot() {
        Enumeration children = this.getAllChildren();
        while (children.hasMoreElements()) {
            BranchGroup child;
            Object o = children.nextElement();
            if (!(o instanceof BranchGroup) || !(child = (BranchGroup)o).getCapability(17)) continue;
            child.detach();
        }
        TransformGroup armBase = new TransformGroup();
        if (this.visualizationProvider.isReady()) {
            this.link = this.visualizationProvider.initializeRobotLinks(armBase, (RobotAppearance)this.robotAppearance, this.visualizationType);
            this.visibilitySwitch = new Switch(-3);
            this.visibilitySwitch.setCapability(18);
            this.visibilitySwitch.addChild((Node)armBase);
            BranchGroup armBaseHolder = new BranchGroup();
            armBaseHolder.addChild((Node)this.visibilitySwitch);
            this.insertChild((Node)armBaseHolder, 0);
            this.visibilitySwitch.setChildMask(this.VISIBLE);
            this.hasBeenDrawn = true;
        }
    }

    public void setVisible(boolean visible) {
        if (!this.hasBeenDrawn) {
            return;
        }
        boolean currentlyVisible = this.visibilitySwitch.getChildMask().get(0);
        if (currentlyVisible && !visible) {
            this.visibilitySwitch.setChildMask(this.HIDDEN);
        } else if (!currentlyVisible && visible) {
            this.visibilitySwitch.setChildMask(this.VISIBLE);
        }
    }

    public void setJointPositions(JointPositionVector jpv) {
        if (!this.hasBeenDrawn) {
            return;
        }
        jpv.transform(this.link);
    }

    public boolean getHasBeenDrawn() {
        return this.hasBeenDrawn;
    }
}

