/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.canvas.impl;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.visualizer.utils.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.utils.SetVisibilityDecorator;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

abstract class AbstractVisualization {
    private SetVisibilityDecorator visibilityDecorator;
    private TransformGroup positionTransformGroup;

    AbstractVisualization() {
    }

    abstract Node[] createActualElementNodes();

    Node getElementNode() {
        if (this.isInitialized()) {
            this.visibilityDecorator.detach();
            return this.visibilityDecorator.getJ3DNode();
        }
        this.positionTransformGroup = new TransformGroup();
        this.positionTransformGroup.setCapability(18);
        for (Node n : this.createActualElementNodes()) {
            this.positionTransformGroup.addChild(n);
        }
        this.visibilityDecorator = new SetVisibilityDecorator(new Node[]{this.positionTransformGroup});
        return this.visibilityDecorator.getJ3DNode();
    }

    void setVisible(boolean visible) {
        if (this.isInitialized()) {
            this.visibilityDecorator.setVisible(visible);
        }
    }

    void setPosition(Pose6d positionInBaseCoordinates) {
        if (this.isInitialized()) {
            Vector3d p = positionInBaseCoordinates.getPos();
            Vector3d o = positionInBaseCoordinates.getRot();
            if (Double.isNaN(p.x) || Double.isNaN(p.y) || Double.isNaN(p.z) || Double.isNaN(o.x) || Double.isNaN(o.y) || Double.isNaN(o.z)) {
                positionInBaseCoordinates = new Pose6d();
            }
            this.positionTransformGroup.setTransform(Pose6dTransformUtils.getTransform3D((Pose6d)positionInBaseCoordinates));
        }
    }

    void setPosition(Transform3D positionInBaseCoordinates) {
        if (this.isInitialized()) {
            this.positionTransformGroup.setTransform(positionInBaseCoordinates);
        }
    }

    protected boolean isInitialized() {
        return this.visibilityDecorator != null;
    }
}

