/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.canvas.impl;

import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.robot.configuration.visualization.VisualizationProvider;
import com.ur.polyscope.visualizer.appearance.impl.AbstractRobotAppearance;
import com.ur.polyscope.visualizer.appearance.impl.MetalRobotAppearance;
import com.ur.polyscope.visualizer.appearance.impl.PositionRobotAppearance;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvas.impl.EmptyRobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.impl.RobotCanvas3DImpl;
import com.ur.polyscope.visualizer.canvas.impl.Settings;
import com.ur.polyscope.visualizer.element.impl.VisualizerElementAggregator;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.util.logging.Log;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class RobotCanvas3DFactoryImpl
implements RobotCanvas3DFactory {
    private final FeaturesLookup featuresLookup;
    private final VisualizationProvider visualizationProvider;
    private final RobotIdentificationProvider robotIdentificationProvider;
    private final ConfigurationState configurationState;
    private final Provider<VisualizerElementAggregator> visualizerElementAggregatorProvider;
    private Set<RobotCanvas3D> debug = new LinkedHashSet<RobotCanvas3D>();
    private boolean debugEnabled = false;

    @Inject
    public RobotCanvas3DFactoryImpl(FeaturesLookup featuresLookup, VisualizationProvider visualizationProvider, RobotIdentificationProvider robotIdentificationProvider, ConfigurationState configurationState, Provider<VisualizerElementAggregator> visualizerElementAggregatorProvider) {
        this.featuresLookup = featuresLookup;
        this.visualizationProvider = visualizationProvider;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.configurationState = configurationState;
        this.visualizerElementAggregatorProvider = visualizerElementAggregatorProvider;
        this.debugEnabled = Settings.enable3DCanvasDebug();
        if (this.debugEnabled) {
            Timer timer = new Timer("Canvas Debug");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    Log.info((String)("Canvas debug start. Total " + RobotCanvas3DFactoryImpl.this.debug.size()));
                    for (RobotCanvas3D d : RobotCanvas3DFactoryImpl.this.debug) {
                        Log.info((String)d.getDebugInfo());
                    }
                    Log.info((String)"Canvas debug end");
                }
            };
            timer.schedule(task, 60000L, 60000L);
        }
    }

    public RobotCanvas3D buildMetalRobot() {
        return this.build(new MetalRobotAppearance());
    }

    public RobotCanvas3D buildPositionRobot() {
        return this.build(new PositionRobotAppearance());
    }

    private RobotCanvas3D build(AbstractRobotAppearance appearance) {
        RobotCanvas3D canvas3D;
        RobotCanvas3D robotCanvas3D = canvas3D = this.hasActualCanvas() ? new RobotCanvas3DImpl(this.featuresLookup, this.visualizationProvider, this.robotIdentificationProvider, this.configurationState, appearance, (VisualizerElementAggregator)this.visualizerElementAggregatorProvider.get()) : new EmptyRobotCanvas3D();
        if (this.debugEnabled) {
            this.debug.add(canvas3D);
        }
        return canvas3D;
    }

    public boolean hasActualCanvas() {
        return Settings.enable3DRender();
    }
}

