/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.canvas.impl;

import com.sun.j3d.utils.pickfast.PickCanvas;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.robot.configuration.visualization.VisualizationProvider;
import com.ur.polyscope.robot.configuration.visualization.VisualizationType;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.visualizer.appearance.impl.AbstractRobotAppearance;
import com.ur.polyscope.visualizer.appearance.impl.Robot3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.impl.COGVisualization;
import com.ur.polyscope.visualizer.canvas.impl.RobotCanvas3dMetrics;
import com.ur.polyscope.visualizer.canvas.impl.UpdateQueueBehavior;
import com.ur.polyscope.visualizer.canvas.impl.UpdateTransitionBehavior;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.element.impl.VisualizerElementAggregator;
import com.ur.polyscope.visualizer.element.impl.VisualizerElementRunnable;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.j3dcomponents.PostRenderer;
import com.ur.swing.SwingUtil;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PickInfo;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

public final class RobotCanvas3DImpl
extends Canvas3D
implements RobotCanvas3D,
RobotStateListener {
    private static final long MINIMUM_FRAME_CYCLE_TIME = 50L;
    private static final String J3D_THREAD_NAME = "J3D-BehaviorScheduler";
    private static final GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
    private RobotIdentificationProvider robotIdentificationProvider;
    private ConfigurationState configurationState;
    private final AbstractRobotAppearance robotAppearance;
    private final VisualizerElementAggregator visualizerElementAggregator;
    private final Robot3D robot;
    private final COGVisualization cog;
    private final Robot3D shadowRobot;
    private final Object visibleMutex = new Object();
    private final Set<J3DComponent> components = new HashSet<J3DComponent>();
    private BranchGroup scene;
    private PickCanvas pickCanvas;
    private RobotTypeIdentifier currentlyDrawnId;
    private boolean robotVisible = true;
    private boolean robotAttached = true;
    private boolean showCoG = false;
    private boolean shadowRobotAttached = false;
    private int transition_time = 800;
    private ViewableGeomFeature viewableGeomFeature;
    private boolean viewFeatureNeedsToBeReset = false;
    private UpdateQueueBehavior updateBehaviorQueue;
    private boolean preSetVisible = false;
    private UpdateTransitionBehavior updateTransitionBehavior;
    private FeaturesLookup featuresLookup;
    private String debugName;
    private RobotCanvas3dMetrics metrics = new RobotCanvas3dMetrics();
    private List<String> callingMethodNameList = new ArrayList<String>();
    private Node shownElementNodes;
    private VisualizerElement element;
    private Runnable alwaysRunVisualizers;

    public RobotCanvas3DImpl(FeaturesLookup featuresLookup, VisualizationProvider visualizationProvider, RobotIdentificationProvider robotIdentificationProvider, ConfigurationState configurationState, AbstractRobotAppearance robotAppearance, VisualizerElementAggregator visualizerElementAggregator) {
        super(graphicsConfiguration);
        AbstractRobotAppearance shadowRobotAppearance;
        this.featuresLookup = featuresLookup;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.configurationState = configurationState;
        this.robotAppearance = robotAppearance;
        this.visualizerElementAggregator = visualizerElementAggregator;
        this.robot = new Robot3D(robotAppearance, VisualizationType.REAL, visualizationProvider);
        this.cog = new COGVisualization();
        try {
            shadowRobotAppearance = (AbstractRobotAppearance)robotAppearance.getClass().newInstance();
            shadowRobotAppearance.metalApp = shadowRobotAppearance.shadowApp;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create shadow robot appearance", e);
        }
        this.shadowRobot = new Robot3D(shadowRobotAppearance, VisualizationType.SHADOW, visualizationProvider);
        this.init();
        this.bindComponentListeners();
        EventNotificationService.register((Object)((Object)this), RobotStateListener.class, (Object)((Object)this));
    }

    public void addNodeToScene(Node node) {
        this.scene.addChild(node);
    }

    private void bindComponentListeners() {
        ComponentsEventForwardingMouseListener listener = new ComponentsEventForwardingMouseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void init() {
        super.setVisible(false);
        this.setDoubleBufferEnable(true);
        SimpleUniverse simpleU = new SimpleUniverse((Canvas3D)this);
        simpleU.getViewer().getView().setMinimumFrameCycleTime(50L);
        this.scene = this.createSceneGraph(simpleU);
        simpleU.addBranchGraph(this.scene);
        this.robotAppearance.addHeadLight(simpleU.getViewingPlatform());
    }

    public ViewableGeomFeature getViewableGeomFeature() {
        return this.viewableGeomFeature;
    }

    public void setViewableGeomFeature(ViewableGeomFeature vgf) {
        this.checkIfUpdatingOnNon3dThread();
        if (RobotState.getLatestRobotState().hasReceivedPositionData) {
            RobotTypeIdentifier typeToDraw = ((RobotIdentification)this.robotIdentificationProvider.get()).getRobotTypeId();
            if (((RobotIdentification)this.robotIdentificationProvider.get()).isRobotTypeSpecified()) {
                typeToDraw = this.robotIdentificationProvider.getDefaultRobotTypeId();
            }
            this.initializeRobotGraphics(typeToDraw);
        }
        this.setRobotVisible(RobotState.getLatestRobotState().hasReceivedPositionData);
        if (vgf != this.viewableGeomFeature) {
            if (this.viewableGeomFeature != null) {
                this.viewableGeomFeature.removeThisReferenceToBeUpdated();
            }
            this.viewableGeomFeature = vgf;
            if (this.viewFeatureNeedsToBeReset) {
                this.viewableGeomFeature.resetView();
                this.viewFeatureNeedsToBeReset = false;
            }
            this.viewableGeomFeature.recalculateTransform();
        }
        this.viewableGeomFeature.setViewSubscriber((ViewableGeomFeature.UpdateCamera)this);
    }

    public void setTransitionEnabled(boolean enabled) {
        this.checkIfUpdatingOnNon3dThread();
        this.updateTransitionBehavior.setTransitionEnabled(enabled);
    }

    public void unsetViewableGeomFeature(ViewableGeomFeature vgf) {
        this.checkIfUpdatingOnNon3dThread();
        if (this.viewableGeomFeature != vgf) {
            Log.trace((String)"Unsetting ViewableGeomFeature that is not the current feature selected.");
            if (vgf != null) {
                vgf.removeThisReferenceToBeUpdated();
            }
        }
        if (this.viewableGeomFeature != null) {
            this.viewableGeomFeature.removeThisReferenceToBeUpdated();
        }
    }

    public void setTransitionTime(float timeInSeconds) {
        if ((double)timeInSeconds > 0.01 && (double)timeInSeconds < 100.0) {
            this.transition_time = (int)(timeInSeconds * 1000.0f);
            this.updateTransitionBehavior.setTransitionTime(this.transition_time);
        }
    }

    private BranchGroup createSceneGraph(SimpleUniverse simpleUniverse) {
        BranchGroup bg = new BranchGroup();
        bg.setCapability(13);
        bg.setCapability(14);
        BoundingSphere boundsLocal = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 400.0);
        Background background = new Background(this.robotAppearance.backgroundColor);
        background.setApplicationBounds((Bounds)boundsLocal);
        bg.addChild((Node)background);
        TransformGroup transformgroup = new TransformGroup();
        this.robotAppearance.addLights(transformgroup);
        bg.addChild((Node)transformgroup);
        bg.addChild((Node)this.robot);
        bg.addChild(this.cog.getElementNode());
        bg.addChild((Node)this.shadowRobot);
        this.updateBehaviorQueue = new UpdateQueueBehavior(this);
        this.updateBehaviorQueue.setSchedulingBounds((Bounds)boundsLocal);
        this.updateTransitionBehavior = new UpdateTransitionBehavior(simpleUniverse.getViewingPlatform().getViewPlatformTransform(), this.transition_time);
        this.updateTransitionBehavior.setSchedulingBounds((Bounds)boundsLocal);
        bg.addChild((Node)this.updateBehaviorQueue);
        bg.addChild((Node)this.updateTransitionBehavior);
        this.pickCanvas = new PickCanvas((Canvas3D)this, bg);
        this.pickCanvas.setMode(2);
        this.pickCanvas.setTolerance(2.0f);
        bg.compile();
        return bg;
    }

    public void setJointAngleVector(JointPositionVector jointPositionVector) {
        this.checkIfUpdatingOnNon3dThread();
        this.robot.setJointPositions(jointPositionVector);
    }

    public void setShadowRobotJointAngleVector(JointPositionVector jointPositionVector) {
        this.checkIfUpdatingOnNon3dThread();
        if (jointPositionVector == null || jointPositionVector.isUndefined()) {
            this.setShadowRobotAttached(false);
        } else {
            this.setShadowRobotAttached(true);
            this.shadowRobot.setJointPositions(jointPositionVector);
        }
    }

    public void setShadowRobotAttached(boolean attach) {
        this.checkIfUpdatingOnNon3dThread();
        this.shadowRobot.setVisible(attach && this.robotVisible);
        this.shadowRobotAttached = attach;
    }

    public void setRobotAttached(boolean attach) {
        this.checkIfUpdatingOnNon3dThread();
        this.robot.setVisible(attach && this.robotVisible);
        this.robotAttached = attach;
    }

    public void updateCamera(ViewableGeomFeature view) {
        this.checkIfUpdatingOnNon3dThread();
        this.updateTransitionBehavior.setTargetTransform(view);
    }

    public void updateRobotState(RobotState robotState) {
        final RobotState rs = robotState;
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                RobotCanvas3DImpl.this.setRobotVisible(rs.hasReceivedPositionData);
                if (RobotCanvas3DImpl.this.configurationState.configurationDataNotReceivedFromController() || !rs.hasReceivedPositionData) {
                    return;
                }
                RobotIdentification robotIdentification = (RobotIdentification)RobotCanvas3DImpl.this.robotIdentificationProvider.get();
                RobotTypeIdentifier robotTypeId = robotIdentification.getRobotTypeId();
                if (robotIdentification.isRobotTypeSpecified() && robotTypeId != RobotCanvas3DImpl.this.currentlyDrawnId) {
                    RobotCanvas3DImpl.this.initializeRobotGraphics(robotTypeId);
                }
            }
        });
    }

    private void initializeRobotGraphics(RobotTypeIdentifier typeToDraw) {
        if (!this.robot.getHasBeenDrawn()) {
            this.addVisualizationElements();
            this.robot.drawRobot();
            this.shadowRobot.drawRobot();
            this.currentlyDrawnId = typeToDraw;
            this.viewFeatureNeedsToBeReset = true;
            if (this.viewableGeomFeature != null) {
                this.viewableGeomFeature.resetView();
                this.viewFeatureNeedsToBeReset = false;
            }
        }
    }

    private void setRobotVisible(boolean robotVisible) {
        this.robotVisible = robotVisible;
        this.robot.setVisible(robotVisible && this.robotAttached);
        this.cog.setVisible(robotVisible && this.showCoG);
        this.shadowRobot.setVisible(robotVisible && this.shadowRobotAttached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(Runnable runnable) {
        Object object = this.visibleMutex;
        synchronized (object) {
            if (this.updateBehaviorQueue != null && this.preSetVisible) {
                this.metrics.addRunnable(runnable.getClass());
                this.updateBehaviorQueue.addQueue(runnable);
            }
        }
    }

    public void alwaysRun(Runnable runnable) {
        this.updateBehaviorQueue.addAlwaysRun(runnable);
    }

    public void clearAlwaysRun() {
        this.updateBehaviorQueue.clearAlwaysRun();
        this.alwaysRunVisualizers = null;
    }

    public boolean hasRunnablesQueued() {
        return !this.updateBehaviorQueue.isEmpty();
    }

    public void setVisible(boolean b) {
        this.setVisible(this.featuresLookup.getFeatureContainer().getCameraView(), b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(ViewableGeomFeature vgf, boolean visible) {
        Object object = this.visibleMutex;
        synchronized (object) {
            this.preSetVisible = visible;
        }
        if (this.preSetVisible) {
            super.setVisible(true);
            if (vgf != null) {
                this.setViewableGeomFeature(vgf);
            }
        } else {
            if (!this.updateBehaviorQueue.isEmpty()) {
                Waiting.pause((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            this.unsetViewableGeomFeature(vgf);
            super.setVisible(false);
        }
    }

    public void postRender() {
        super.postRender();
        for (PostRenderer postRenderer : this.components) {
            postRenderer.render((Graphics2D)this.getGraphics2D());
        }
        this.getGraphics2D().flush(false);
    }

    public void addJ3DComponent(J3DComponent component) {
        this.components.add(component);
    }

    public Iterable<J3DComponent> getJ3DComponents() {
        return this.components;
    }

    public PickInfo pickClosest(MouseEvent mouseEvent) {
        this.pickCanvas.setShapeLocation(mouseEvent);
        return this.pickCanvas.pickClosest();
    }

    public Component getComponent() {
        return this;
    }

    public boolean isActualCanvas() {
        return true;
    }

    public void setDebugName(String debugName) {
        this.debugName = debugName;
        if (this.getName() != null) {
            this.setName(debugName);
        }
    }

    public String getDebugName() {
        return this.debugName;
    }

    public String getDebugInfo() {
        return "Name: " + this.debugName + ". Child count: " + this.countChildrenRecursive() + ". Visible: " + this.isVisible() + " Metrics: " + this.metrics.getDebug();
    }

    public void updateCoG(Pose6d cogInBaseCoordinates) {
        this.checkIfUpdatingOnNon3dThread();
        this.cog.setPosition(cogInBaseCoordinates);
    }

    public void updateCoGDimensions(Length length, Length width, Length height) {
        this.checkIfUpdatingOnNon3dThread();
        this.cog.updateDimensions((float)length.asDouble(), (float)width.asDouble(), (float)height.asDouble());
    }

    public void setShowCoG(boolean showCoG) {
        this.checkIfUpdatingOnNon3dThread();
        this.cog.setVisible(showCoG && this.robotVisible);
        this.showCoG = showCoG;
    }

    private int countChildrenRecursive(Enumeration e) {
        int count = 0;
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            ++count;
            if (!(o instanceof Group)) continue;
            count += this.countChildrenRecursive(((Group)o).getAllChildren());
        }
        return count;
    }

    private int countChildrenRecursive() {
        return this.countChildrenRecursive(this.scene.getAllChildren());
    }

    private void checkIfUpdatingOnNon3dThread() {
        if (this.isNotRunningOn3dThread() && this.hasNotLoggedForMethod()) {
            this.logWrongUseOf3dMethod();
        }
    }

    private boolean isNotRunningOn3dThread() {
        return !Thread.currentThread().getName().startsWith(J3D_THREAD_NAME);
    }

    private boolean hasNotLoggedForMethod() {
        return !this.callingMethodNameList.contains(this.getMethodName());
    }

    private void logWrongUseOf3dMethod() {
        String callingMethodName = this.getMethodName();
        this.callingMethodNameList.add(callingMethodName);
        Log.debug((String)("Updating " + this.getDebugName() + " using method " + callingMethodName));
    }

    private String getMethodName() {
        return Thread.currentThread().getStackTrace()[4].getMethodName();
    }

    public void showDynamicElements(Collection<VisualizerElement> dynamicElements) {
        this.showElements(null, dynamicElements);
    }

    public void showStaticElements(Collection<VisualizerElementType> staticElements) {
        this.showElements(staticElements, null);
    }

    public void showElements(Collection<VisualizerElementType> staticElements, Collection<VisualizerElement> dynamicElements) {
        this.removeExistingElementVisualization();
        this.element = this.visualizerElementAggregator.buildElements(staticElements, dynamicElements);
        if (this.robot.getHasBeenDrawn()) {
            this.addVisualizationElements();
        }
    }

    private void addVisualizationElements() {
        if (this.element != null) {
            this.shownElementNodes = this.element.getElementNode();
            this.scene.addChild(this.shownElementNodes);
            this.alwaysRunVisualizers = new VisualizerElementRunnable(this.element);
            this.alwaysRun(this.alwaysRunVisualizers);
        }
    }

    private void removeExistingElementVisualization() {
        if (this.alwaysRunVisualizers != null) {
            this.updateBehaviorQueue.removeAlwaysRun(this.alwaysRunVisualizers);
            this.alwaysRunVisualizers = null;
        }
        if (this.shownElementNodes != null && this.shownElementNodes.getParent() != null) {
            this.scene.removeChild(this.shownElementNodes);
            this.shownElementNodes = null;
        }
    }

    UpdateQueueBehavior getUpdateBehaviorQueue() {
        return this.updateBehaviorQueue;
    }

    public void enter() {
        if (this.robot.getHasBeenDrawn()) {
            if (this.alwaysRunVisualizers != null) {
                this.updateBehaviorQueue.removeAlwaysRun(this.alwaysRunVisualizers);
            }
            this.alwaysRunVisualizers = new VisualizerElementRunnable(this.element);
            this.alwaysRun(this.alwaysRunVisualizers);
        }
    }

    public void exit() {
        if (this.alwaysRunVisualizers != null) {
            this.clearAlwaysRun();
        }
    }

    private final class ComponentsEventForwardingMouseListener
    implements MouseListener,
    MouseMotionListener {
        private ComponentsEventForwardingMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleEvents(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleEvents(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.handleEvents(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.handleEvents(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleEvents(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handleEvents(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleEvents(e);
        }

        private void handleEvents(MouseEvent e) {
            for (J3DComponent each : RobotCanvas3DImpl.this.components) {
                each.dispatchEvent((AWTEvent)e);
            }
        }
    }
}

