/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.canvas.impl;

import com.ur.util.logging.Log;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.media.j3d.Behavior;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;

class UpdateQueueBehavior
extends Behavior {
    private static final int CAPACITY = 50;
    private final WakeupOnElapsedFrames criteria = new WakeupOnElapsedFrames(1);
    private final ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue(50);
    private final List<Runnable> alwaysRun = new CopyOnWriteArrayList<Runnable>();
    private final Canvas3D canvas3D;
    private boolean queueFull;

    public UpdateQueueBehavior(Canvas3D canvas3D) {
        this.canvas3D = canvas3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        if (this.containsWakeupCriteria(criteria, WakeupOnElapsedFrames.class)) {
            try {
                for (Runnable each : this.alwaysRun) {
                    each.run();
                }
                while (!this.queue.isEmpty()) {
                    Runnable runner = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (runner != null) {
                        runner.run();
                        continue;
                    }
                    Log.error((String)("Poll timed out while waiting for 3D graphics queue. Canvas: " + this.canvas3D.getName()));
                }
            }
            catch (InterruptedException e) {
                Log.error((String)("Interrupted while waiting for 3D graphics queue. Canvas: " + this.canvas3D.getName()));
            }
            finally {
                this.wakeupOn((WakeupCondition)this.criteria);
            }
        }
    }

    private boolean containsWakeupCriteria(Enumeration<?> criteria, Class<?> type) {
        while (criteria.hasMoreElements()) {
            if (!type.isInstance(criteria.nextElement())) continue;
            return true;
        }
        return false;
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(1));
    }

    void addQueue(Runnable runnable) {
        try {
            if (this.canvas3D.isRendererRunning()) {
                this.offerToQueue(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            Log.error((String)("3D graphics queue is full. Canvas: " + this.canvas3D.getName()));
        }
    }

    private void offerToQueue(Runnable runnable) {
        if (this.queue.offer(runnable)) {
            this.logQueueNoLongerFull();
        } else {
            this.logQueueFull();
        }
    }

    private void logQueueNoLongerFull() {
        if (this.queueFull) {
            Log.info((String)("Queue is no longer full. Canvas: " + this.canvas3D.getName()));
            this.queueFull = false;
        }
    }

    private void logQueueFull() {
        if (!this.queueFull) {
            Log.error((String)("Trying to put event onto a full 3D graphics queue. Canvas: " + this.canvas3D.getName()));
            this.queueFull = true;
        }
    }

    void addAlwaysRun(Runnable runnable) {
        if (this.alwaysRun.size() < 50) {
            this.alwaysRun.add(runnable);
        } else {
            Log.error((String)("Always run 3D graphics queue has reached capacity. Not adding more. Canvas:" + this.canvas3D.getName()));
        }
    }

    void removeAlwaysRun(Runnable runnable) {
        if (!this.alwaysRun.remove(runnable)) {
            Log.error((String)"Always run runnable not found in queue!");
        }
    }

    void clearAlwaysRun() {
        this.alwaysRun.clear();
    }

    boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

