/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.canvas.impl;

import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.util.logging.Log;
import java.util.Enumeration;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class UpdateTransitionBehavior
extends Behavior {
    private final WakeupOnElapsedFrames CRITERIA = new WakeupOnElapsedFrames(1);
    private final TransformGroup tg;
    private final Transform3D pannedTransform = new Transform3D();
    private final Transform3D fromfeatureTrans = new Transform3D();
    private final Transform3D fromFeatureTransInv = new Transform3D();
    private final Transform3D fromCameraTrans = new Transform3D();
    private final Transform3D toFeatureTrans = new Transform3D();
    private final Transform3D toFeatureTransInv = new Transform3D();
    private final Transform3D toFeatureCameraTrans = new Transform3D();
    private ViewableGeomFeature geomFeature;
    private ViewableGeomFeature currentGeomFeature;
    private float i;
    private boolean transitionEnabled = true;
    private long currentTime;
    private int transitionTime;

    UpdateTransitionBehavior(TransformGroup viewPlatformTransform, int transitionTime) {
        this.tg = viewPlatformTransform;
        this.transitionTime = transitionTime;
        this.i = transitionTime / 50;
    }

    public void setTransitionTime(int transitionTime) {
        this.transitionTime = transitionTime;
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        if (this.containsWakeupCriteria(criteria, WakeupOnElapsedFrames.class)) {
            this.wakeupOn((WakeupCondition)this.CRITERIA);
            if (this.currentGeomFeature == null) {
                this.currentGeomFeature = this.geomFeature;
                if (this.isCameraTransformNotNull(this.currentGeomFeature)) {
                    this.setPannedTransform(this.currentGeomFeature);
                }
            }
            if (this.geomFeature != null && this.currentGeomFeature != this.geomFeature) {
                ViewableGeomFeature prevGeomFeature = this.currentGeomFeature;
                this.currentGeomFeature = this.geomFeature;
                this.i = 0.0f;
                this.currentTime = System.currentTimeMillis();
                this.fromfeatureTrans.set(prevGeomFeature.getTransform());
                this.fromFeatureTransInv.set(prevGeomFeature.getTransform());
                this.fromFeatureTransInv.invert();
                this.fromCameraTrans.mul(this.fromFeatureTransInv, prevGeomFeature.getCameraTransform());
                this.toFeatureTrans.set(this.currentGeomFeature.getTransform());
                this.toFeatureTransInv.set(this.currentGeomFeature.getTransform());
                this.toFeatureTransInv.invert();
                this.toFeatureCameraTrans.mul(this.toFeatureTransInv, this.currentGeomFeature.getCameraTransform());
                this.geomFeature = null;
            }
            if (this.isCameraTransformNotNull(this.currentGeomFeature)) {
                this.setPannedTransform(this.currentGeomFeature);
            }
            if (this.transitionEnabled) {
                if (this.i > (float)this.transitionTime) {
                    this.i = 0.0f;
                    this.transitionEnabled = false;
                } else {
                    try {
                        Transform3D transBaseFeatureInt = this.interpolateFromToAlpha(this.fromfeatureTrans, this.toFeatureTrans, this.i / (float)this.transitionTime);
                        Transform3D cameraTransInterpolated = this.interpolateFromToAlpha(this.fromCameraTrans, this.toFeatureCameraTrans, this.i / (float)this.transitionTime);
                        transBaseFeatureInt.mul(cameraTransInterpolated);
                        this.pannedTransform.set(transBaseFeatureInt);
                    }
                    catch (BadTransformException bte) {
                        Log.error((String)"Caught BadTransformException: ", (Throwable)bte);
                        this.pannedTransform.set(new Transform3D());
                    }
                    catch (Exception e) {
                        Log.error((String)"Trying to pan", (Throwable)e);
                        this.pannedTransform.set(new Transform3D());
                    }
                    finally {
                        this.tg.setTransform(this.pannedTransform);
                    }
                    this.i += (float)(System.currentTimeMillis() - this.currentTime);
                    this.currentTime = System.currentTimeMillis();
                }
            }
        }
    }

    private boolean containsWakeupCriteria(Enumeration<?> criteria, Class<?> type) {
        while (criteria.hasMoreElements()) {
            if (!type.isInstance(criteria.nextElement())) continue;
            return true;
        }
        return false;
    }

    private boolean isCameraTransformNotNull(ViewableGeomFeature feature) {
        return feature != null;
    }

    private void setPannedTransform(ViewableGeomFeature feature) {
        try {
            feature.getCameraTransform(this.pannedTransform);
            this.tg.setTransform(this.pannedTransform);
        }
        catch (Exception e) {
            Log.error((String)"Failed to set transform", (Throwable)e);
            this.pannedTransform.set(new Transform3D());
            this.tg.setTransform(this.pannedTransform);
        }
    }

    void setTransitionEnabled(boolean enabled) {
        this.transitionEnabled = enabled;
    }

    void setTargetTransform(ViewableGeomFeature geomFeature) {
        this.geomFeature = geomFeature;
    }

    private Transform3D interpolateFromToAlpha(Transform3D tFrom, Transform3D tTo, double alpha) {
        Quat4d qFrom = new Quat4d();
        Vector3d vFrom = new Vector3d();
        tFrom.get(vFrom);
        tFrom.get(qFrom);
        Quat4d qTo = new Quat4d();
        Vector3d vTo = new Vector3d();
        tTo.get(vTo);
        tTo.get(qTo);
        Quat4d qFromTo = new Quat4d();
        qFromTo.interpolate(qFrom, qTo, alpha);
        Vector3d vFromTo = new Vector3d();
        vFromTo.sub((Tuple3d)vTo, (Tuple3d)vFrom);
        vFromTo.scale(alpha);
        vFromTo.add((Tuple3d)vFrom);
        Transform3D result = new Transform3D();
        result.set(qFromTo, vFromTo, 1.0);
        return result;
    }
}

