/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.canvas.impl;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvas.UpdateRobotGraphicsRunnable;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.polyscope.visualizer.canvas.impl.ShowCoGGraphicsRunnable;
import com.ur.polyscope.visualizer.canvas.impl.UpdateCoGDimensionsRunnable;
import com.ur.polyscope.visualizer.canvas.impl.UpdateCoGGraphicsRunnable;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import java.awt.Component;
import java.util.Arrays;
import javax.inject.Inject;

public class VisualizerFactoryImpl
implements VisualizerFactory {
    private RobotCanvas3DFactory factory;
    private FeaturesLookup featuresLookup;

    @Inject
    VisualizerFactoryImpl(RobotCanvas3DFactory factory, FeaturesLookup featuresLookup) {
        this.factory = factory;
        this.featuresLookup = featuresLookup;
    }

    public Component createCanvas() {
        RobotCanvas3D canvas = this.factory.buildMetalRobot();
        ProgramVisualization programVisualizer = new ProgramVisualization(canvas.isActualCanvas());
        if (canvas.isActualCanvas()) {
            canvas.addNodeToScene(programVisualizer.getElementNode());
        }
        programVisualizer.clearVisualization();
        new URCanvas3DFingerDragViewShifter(canvas);
        return (Component)canvas;
    }

    private RobotCanvas3D castRobotCanvas3D(Component canvas) {
        return (RobotCanvas3D)canvas;
    }

    public void showRobot(Component canvas, JointPositionVector actualJointPositionVector) {
        RobotCanvas3D robotCanvas3D = this.castRobotCanvas3D(canvas);
        robotCanvas3D.addQueue((Runnable)new UpdateRobotGraphicsRunnable(robotCanvas3D, actualJointPositionVector));
    }

    public void showZoomControls(Component canvas, boolean show) {
        RobotCanvas3D robotCanvas3D = this.castRobotCanvas3D(canvas);
        ViewBehaviorWrapper wrapper = new ViewBehaviorWrapper(this.featuresLookup);
        ZoomRenderer zr = new ZoomRenderer(robotCanvas3D.getComponent(), (ViewBehaviorHolder)wrapper);
        robotCanvas3D.addJ3DComponent((J3DComponent)zr);
        robotCanvas3D.alwaysRun((Runnable)new UpdateZoomInCanvas((ViewBehaviorHolder)wrapper));
    }

    public void setDebugName(Component canvas, String debugName) {
        RobotCanvas3D robotCanvas3D = this.castRobotCanvas3D(canvas);
        robotCanvas3D.setDebugName(debugName);
    }

    public void showCoG(Component canvas, boolean show) {
        RobotCanvas3D robotCanvas3D = this.castRobotCanvas3D(canvas);
        robotCanvas3D.addQueue((Runnable)new ShowCoGGraphicsRunnable(robotCanvas3D, show));
    }

    public void updateCoG(Component canvas, Pose6d cogInBaseCoordinates) {
        RobotCanvas3D robotCanvas3D = this.castRobotCanvas3D(canvas);
        robotCanvas3D.addQueue((Runnable)new UpdateCoGGraphicsRunnable(robotCanvas3D, cogInBaseCoordinates));
    }

    public void updateCoGDimensions(Component canvas, Length length, Length width, Length height) {
        RobotCanvas3D robotCanvas3D = this.castRobotCanvas3D(canvas);
        robotCanvas3D.addQueue((Runnable)new UpdateCoGDimensionsRunnable(robotCanvas3D, length, width, height));
    }

    public void showStaticElements(Component canvas, VisualizerElementType ... types) {
        RobotCanvas3D robotCanvas3D = this.castRobotCanvas3D(canvas);
        robotCanvas3D.showStaticElements(Arrays.asList(types));
    }
}

