/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.visualizer.element.impl;

import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;

public class VisualizerElementAggregator {
    private final Set<VisualizerElement> visualizers;
    private final RobotCanvas3DFactory factory;

    @Inject
    public VisualizerElementAggregator(Set<VisualizerElement> visualizers, RobotCanvas3DFactory factory) {
        this.visualizers = visualizers;
        this.factory = factory;
    }

    public VisualizerElement buildElements(Collection<VisualizerElementType> staticElements, Collection<VisualizerElement> dynamicElements) {
        HashSet<VisualizerElement> filteredElements = new HashSet<VisualizerElement>();
        if (staticElements != null) {
            for (VisualizerElement visualizerElement : this.visualizers) {
                if (!staticElements.contains(visualizerElement.getElementType())) continue;
                filteredElements.add(visualizerElement);
            }
        }
        if (dynamicElements != null) {
            filteredElements.addAll(dynamicElements);
        }
        return new CombinedElement(filteredElements, this.factory);
    }

    private class CombinedElement
    implements VisualizerElement {
        private final Set<VisualizerElement> visualizers;
        private final RobotCanvas3DFactory factory;

        public CombinedElement(Set<VisualizerElement> visualizers, RobotCanvas3DFactory factory) {
            this.visualizers = visualizers;
            this.factory = factory;
        }

        public VisualizerElementType getElementType() {
            return null;
        }

        public Node getElementNode() {
            if (this.factory != null && this.factory.hasActualCanvas()) {
                BranchGroup result = new BranchGroup();
                for (VisualizerElement each : this.visualizers) {
                    result.addChild(each.getElementNode());
                }
                return result;
            }
            return null;
        }

        public void update() {
            if (this.factory != null && this.factory.hasActualCanvas()) {
                for (VisualizerElement visualizer : this.visualizers) {
                    visualizer.update();
                }
            }
        }
    }
}

