/*
 * Decompiled with CFR 0.152.
 */
package com.ur.bean;

import com.ur.util.logging.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class InvokeField {
    private Object target;
    private Field field;

    public InvokeField(Object target, Field field) {
        this.target = target;
        this.field = field;
        field.setAccessible(true);
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public void set(Object value) {
        try {
            this.field.setAccessible(true);
            this.field.set(this.target, value);
        }
        catch (Exception e) {
            Log.error("Failed to set field: " + this.field.getName(), e);
        }
    }

    public <T> T get() {
        try {
            this.field.setAccessible(true);
            return (T)this.field.get(this.target);
        }
        catch (Exception e) {
            Log.warning("Failed to get field value: " + this.field.getName(), e);
            return null;
        }
    }

    public <T extends Annotation> boolean isWithAnnotation(Class<T> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.field.getAnnotation(annotation);
    }

    public String getName() {
        return this.field.getName();
    }
}

