/*
 * Decompiled with CFR 0.152.
 */
package com.ur.bean;

import com.ur.bean.TargetProvider;
import com.ur.lang.ClassUtils;
import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.util.logging.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class InvokeMethod {
    public static final InvokeMethod NULL = new InvokeMethod();
    private TargetProvider<?> targetProvider;
    private Method method;

    private InvokeMethod() {
    }

    private InvokeMethod(TargetProvider<?> targetProvider, Method method) {
        this.targetProvider = targetProvider;
        this.method = method;
        method.setAccessible(true);
    }

    public Object invoke(Object ... args) throws Throwable {
        if (this.isNullObject()) {
            return null;
        }
        try {
            return this.method.invoke(this.targetProvider.getTarget(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            Log.warning("Failed to invoke: " + this.method.getName() + "(" + StringUtils.joinStringsWith(", ", this.method.getParameterTypes()) + ")", e);
            return null;
        }
    }

    private boolean isNullObject() {
        return this.targetProvider == null || this.method == null;
    }

    public <T extends Annotation> boolean hasAnnotationAndParameters(Class<T> annotationType, Class<?> ... desiredParameterTypes) {
        return this.hasAnnotation(annotationType) && this.hasParameters(desiredParameterTypes);
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return ClassUtils.hasAnnotation(this.method, annotation);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return ClassUtils.getAnnotation(this.method, annotation);
    }

    public boolean hasParameters(Class<?> ... desiredParameterTypes) {
        return Arrays.equals(this.method.getParameterTypes(), desiredParameterTypes);
    }

    public String toString() {
        if (this.isNullObject()) {
            return "InvokeMethod: NULL";
        }
        return "InvokeMethod: " + this.targetProvider.getTargetType() + "." + this.method.getName();
    }

    public boolean isReturning(Class<?> class1) {
        return EqualsUtil.equals(this.method.getReturnType(), class1);
    }

    public static InvokeMethod createInvokeMethodWithFixedTarget(final Object target, Method method) {
        TargetProvider<Object> targetProvider = new TargetProvider<Object>(){

            @Override
            public Class<?> getTargetType() {
                return target.getClass();
            }

            @Override
            public Object getTarget() {
                return target;
            }
        };
        return new InvokeMethod(targetProvider, method);
    }

    public static InvokeMethod createInvokeMethodWithDynamicTarget(TargetProvider<?> targetProvider, Method method) {
        return new InvokeMethod(targetProvider, method);
    }
}

