/*
 * Decompiled with CFR 0.152.
 */
package com.ur.bean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class PropertyListenerInvocationHandler
implements InvocationHandler {
    PropertyChangeSupport support;
    private Object target;

    public PropertyListenerInvocationHandler(Object target) {
        this.target = target;
        this.support = new PropertyChangeSupport(target);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (method.getName().equals("addPropertyChangeListener")) {
            this.support.addPropertyChangeListener((PropertyChangeListener)args[0]);
            return null;
        }
        if (method.getName().equals("fireEvent")) {
            PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)args[0];
            this.support.firePropertyChange(propertyChangeEvent);
        }
        if (method.getName().startsWith("set")) {
            String property = method.getName().substring(3);
            Object oldValue = this.getOldValue(property);
            method.invoke(this.target, args);
            this.support.firePropertyChange(property, oldValue, args[0]);
        } else {
            result = method.invoke(this.target, args);
        }
        return result;
    }

    private Object getOldValue(String property) {
        Method getMethod = this.tryToFetchMethod("get" + property);
        if (getMethod == null) {
            getMethod = this.tryToFetchMethod("is" + property);
        }
        if (getMethod == null) {
            return null;
        }
        try {
            return getMethod.invoke(this.target, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to invoke method");
        }
    }

    private Method tryToFetchMethod(String methodName) {
        try {
            return this.target.getClass().getMethod(methodName, new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

