/*
 * Decompiled with CFR 0.152.
 */
package com.ur.bean;

import com.ur.util.logging.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;

public class ReflectUtils {
    private ReflectUtils() {
    }

    public static Object getProperty(Object target, String fieldName, Object defaultValue) {
        try {
            return BeanUtils.getProperty((Object)target, (String)fieldName);
        }
        catch (InvocationTargetException e) {
            Log.error("Found get " + fieldName + " but get method most likely had an exception thrown", e);
            return defaultValue;
        }
        catch (Exception ex) {
            Log.error("Failed to getProperty in " + target.getClass().getName() + "." + fieldName, ex);
            return defaultValue;
        }
    }

    public static void setFieldOnClass(Class<?> target, String fieldName, Object value) {
        try {
            Field field = target.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (Exception e) {
            Log.error("Failed to set field on " + target.getClass().getName() + "." + fieldName, e);
        }
    }

    public static void setFinalStaticFieldOnClass(Class<?> target, String fieldName, Object value) {
        try {
            Field field = target.getDeclaredField(fieldName);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(target, value);
            modifiersField.setInt(field, field.getModifiers() | 0x10);
            modifiersField.setAccessible(false);
        }
        catch (Exception e) {
            Log.error("Failed to set final static field on " + target.getClass().getName() + "." + fieldName, e);
        }
    }

    public static void setProperty(Object target, String fieldName, Object value) {
        try {
            BeanUtils.setProperty((Object)target, (String)fieldName, (Object)value);
        }
        catch (InvocationTargetException e) {
            Log.error("Found set " + fieldName + " but set method most likely had an exception thrown", e);
        }
        catch (Exception ex) {
            Log.error("Failed to setProperty in " + target.getClass().getName() + "." + fieldName, ex);
        }
    }
}

