/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.ur.injection.ChainingInterceptor;
import com.ur.lang.ClassUtils;
import com.ur.reversible.ReversibleConsumer;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class CompoundChangeInterceptor<T>
extends ChainingInterceptor {
    private final Class<? extends Annotation> compoundChangeTag;
    private ReversibleConsumer<T> consumer;

    public CompoundChangeInterceptor(Class<? extends Annotation> compoundChangeTag, MethodInterceptor next) {
        super(next);
        this.compoundChangeTag = compoundChangeTag;
    }

    public void setConsumer(ReversibleConsumer<T> consumer) {
        this.consumer = consumer;
    }

    @Override
    protected boolean shouldProcess(MethodInvocation invocation) {
        return !this.consumer.isSequenceStarted() && ClassUtils.hasAnnotation(invocation.getMethod(), this.compoundChangeTag);
    }

    @Override
    protected Object process(MethodInvocation invocation) throws Throwable {
        try {
            this.consumer.startSequence();
            Object object = this.next == null ? invocation.proceed() : this.next.invoke(invocation);
            return object;
        }
        finally {
            this.consumer.endSequence();
        }
    }
}

