/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.ur.injection.ChainingInterceptor;
import com.ur.lang.ClassUtils;
import com.ur.reversible.ReversibleConsumer;
import com.ur.reversible.TreeNodeInsertRemove;
import com.ur.util.logging.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DefaultTreeModelChangeInterceptor<T extends DefaultMutableTreeNode>
extends ChainingInterceptor {
    private final Class<T> targetType;
    private final Class<? extends Annotation> treeChangeTag;
    private ReversibleConsumer<T> consumer;

    public DefaultTreeModelChangeInterceptor(Class<T> targetType, Class<? extends Annotation> treeChangeTag, MethodInterceptor next) {
        super(next);
        this.targetType = targetType;
        this.treeChangeTag = treeChangeTag;
    }

    public void setConsumer(ReversibleConsumer<T> consumer) {
        this.consumer = consumer;
    }

    @Override
    protected boolean shouldProcess(MethodInvocation invocation) {
        return ClassUtils.hasAnnotation(invocation.getMethod(), this.treeChangeTag);
    }

    @Override
    protected Object process(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        String methodName = method.getName();
        Object[] arguments = invocation.getArguments();
        DefaultTreeModel treeModel = null;
        DefaultMutableTreeNode parent = null;
        DefaultMutableTreeNode child = null;
        int index = -1;
        boolean insertion = true;
        if (invocation.getThis() instanceof DefaultTreeModel) {
            treeModel = (DefaultTreeModel)invocation.getThis();
            if (methodName.equals("insertNodeInto") && arguments.length == 3 && this.targetType.isInstance(arguments[0]) && this.targetType.isInstance(arguments[1]) && arguments[2] instanceof Integer) {
                child = (DefaultMutableTreeNode)arguments[0];
                parent = (DefaultMutableTreeNode)arguments[1];
                index = (Integer)arguments[2];
            } else if (methodName.equals("removeNodeFromParent") && arguments.length == 1 && this.targetType.isInstance(arguments[0])) {
                child = (DefaultMutableTreeNode)arguments[0];
                if (this.targetType.isInstance(child.getParent())) {
                    parent = (DefaultMutableTreeNode)child.getParent();
                    index = parent.getIndex(child);
                }
                insertion = false;
            }
        }
        Object result = null;
        boolean success = true;
        try {
            result = invocation.proceed();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            success = false;
        }
        if (success && child != null && parent != null) {
            TreeNodeInsertRemove<Object> reversible = this.makeReversible(treeModel, parent, child, index, insertion);
            this.consumer.consume(reversible);
        } else {
            Log.error("Could not construct reversible for the call " + method.getName());
        }
        return result;
    }

    protected TreeNodeInsertRemove<T> makeReversible(DefaultTreeModel treeModel, T parent, T child, int index, boolean insertion) {
        return new TreeNodeInsertRemove<T>(treeModel, parent, child, index, insertion);
    }
}

