/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.ur.injection.Binder;
import com.ur.injection.GuiceBindException;
import com.ur.injection.HasKey;
import com.ur.injection.ServicesBinder;
import com.ur.util.logging.Log;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Qualifier;

class GuiceBinder
extends AbstractModule
implements Binder {
    Collection<ServicesBinder> binders;
    Map<String, Class<?>> boundClass = new HashMap();
    private final List<Object> objectsToBeInjected = new ArrayList<Object>();
    private final List<Module> toInstall = new ArrayList<Module>();
    private final List<BindIfAbsent> bindIfAbsent = new ArrayList<BindIfAbsent>();
    private final List<BindIfAbsentWithQualifier> bindIfAbsentWithQualifier = new ArrayList<BindIfAbsentWithQualifier>();

    public GuiceBinder(Collection<ServicesBinder> binders) {
        this.binders = binders;
    }

    @Override
    public <T> void bindInstance(Class<T> serviceInterface, T serviceImplementation) {
        this.validateInterface(serviceInterface);
        try {
            HasKey annotation = serviceImplementation.getClass().getAnnotation(HasKey.class);
            String value = annotation.value();
            this.bind(serviceInterface).annotatedWith((Annotation)Names.named((String)value)).toInstance(serviceImplementation);
        }
        catch (Exception exception) {
            this.bind(serviceInterface).toInstance(serviceImplementation);
        }
    }

    @Override
    public <T> void bindClass(Class<T> serviceInterface, Class<? extends T> serviceImplementation) {
        this.validateInterface(serviceInterface);
        try {
            HasKey annotation = serviceImplementation.getAnnotation(HasKey.class);
            String value = annotation.value();
            this.bind(serviceInterface).annotatedWith((Annotation)Names.named((String)value)).to(serviceImplementation);
        }
        catch (Exception exception) {
            this.bind(serviceInterface).to(serviceImplementation);
        }
    }

    @Override
    public <T> void bindInstanceWithQualifier(Class<T> serviceInterface, T serviceImplementation, Class<? extends Annotation> qualifier) {
        this.validateInterfaceWithQualifier(serviceInterface, qualifier);
        try {
            this.bind(serviceInterface).annotatedWith(qualifier).toInstance(serviceImplementation);
        }
        catch (Exception e) {
            Log.error("Failed to bind with qualifier", e);
            this.bind(serviceInterface).toInstance(serviceImplementation);
        }
    }

    @Override
    public <T> void bindClassWithQualifier(Class<T> serviceInterface, Class<? extends T> serviceImplementation, Class<? extends Annotation> qualifier) {
        this.validateInterfaceWithQualifier(serviceInterface, qualifier);
        try {
            this.bind(serviceInterface).annotatedWith(qualifier).to(serviceImplementation);
        }
        catch (Exception exception) {
            this.bind(serviceInterface).to(serviceImplementation);
        }
    }

    @Override
    public <T> void bindClassIfAbsent(Class<T> serviceInterface, Class<? extends T> serviceImplementation) {
        this.bindIfAbsent.add(new BindIfAbsent<T>(serviceInterface, serviceImplementation));
    }

    @Override
    public <T> void bindClassWithQualifierIfAbsent(Class<T> serviceInterface, Class<? extends T> serviceImplementation, Class<? extends Annotation> qualifier) {
        this.bindIfAbsentWithQualifier.add(new BindIfAbsentWithQualifier<T>(serviceInterface, serviceImplementation, qualifier));
    }

    @Override
    public <T> void bindToExtensionPoint(Class<T> extensionInterface, Class<? extends T> extensionImplementation) {
        this.validateInterface(extensionInterface);
        Multibinder uriBinder = Multibinder.newSetBinder((com.google.inject.Binder)this.binder(), extensionInterface);
        uriBinder.addBinding().to(extensionImplementation);
    }

    @Override
    public <T> void bindKeyToExtensionPoint(Object key, Class<T> extensionInterface, Class<? extends T> extensionImplementation) {
        this.validateInterface(extensionInterface);
        MapBinder mapBinder = MapBinder.newMapBinder((com.google.inject.Binder)this.binder(), key.getClass(), extensionInterface);
        mapBinder.addBinding(key).to(extensionImplementation);
    }

    @Override
    public <T> void bindKeyToExtensionPoint(Enum<?> enumValue, Class<T> extensionInterface, Class<? extends T> extensionImplementation) {
        this.bindKeyToExtensionPoint((Object)enumValue, extensionInterface, extensionImplementation);
    }

    @Override
    public <T> void bindToExtensionPoint(Class<T> extensionInterface, T extensionImplementation) {
        this.validateInterface(extensionInterface);
        Multibinder uriBinder = Multibinder.newSetBinder((com.google.inject.Binder)this.binder(), extensionInterface);
        uriBinder.addBinding().toInstance(extensionImplementation);
    }

    @Override
    public <T> void bindProvider(Class<T> serviceInterface, final javax.inject.Provider<T> provider) {
        this.validateInterface(serviceInterface);
        Annotation[] annotationArray = provider.getClass().getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation each = annotationArray[n2];
            if (each.annotationType().isAnnotationPresent(Qualifier.class)) {
                this.bind(serviceInterface).annotatedWith(each).toProvider(new Provider<T>(){

                    public T get() {
                        return provider.get();
                    }
                });
                return;
            }
            ++n2;
        }
        this.bind(serviceInterface).toProvider(new Provider<T>(){

            public T get() {
                return provider.get();
            }
        });
    }

    private <T> void validateInterface(Class<T> serviceInterface) {
        this.validateInterfaceWithQualifier(serviceInterface, null);
    }

    private <T> void validateInterfaceWithQualifier(Class<T> serviceInterface, Class<?> qualifier) {
        String key = String.valueOf(serviceInterface.getName()) + (qualifier == null ? "" : ":" + qualifier.getName());
        if (this.boundClass.containsKey(key) && this.boundClass.get(key) != serviceInterface) {
            throw new GuiceBindException(serviceInterface);
        }
        this.boundClass.put(key, serviceInterface);
    }

    @Override
    public <T> void bindProvider(Class<T> serviceInterface, Class<? extends javax.inject.Provider<T>> provider) {
        Annotation[] annotationArray = provider.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation each = annotationArray[n2];
            if (each.annotationType().isAnnotationPresent(Qualifier.class)) {
                this.bind(serviceInterface).annotatedWith(each).toProvider(provider);
                return;
            }
            ++n2;
        }
        this.bind(serviceInterface).toProvider(provider);
    }

    @Override
    public <T> void bindProvider(TypeLiteral<T> serviceInterface, Class<? extends javax.inject.Provider<? extends T>> provider) {
        Annotation[] annotationArray = provider.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation each = annotationArray[n2];
            if (each.annotationType().isAnnotationPresent(Qualifier.class)) {
                this.bind(serviceInterface).annotatedWith(each).toProvider(provider);
                return;
            }
            ++n2;
        }
        this.bind(serviceInterface).toProvider(provider);
    }

    @Override
    public <T> void bindProviderWithQualifier(Class<T> serviceInterface, Class<? extends javax.inject.Provider<T>> provider, Class<? extends Annotation> qualifier) {
        this.bind(serviceInterface).annotatedWith(qualifier).toProvider(provider);
    }

    @Override
    public <T> void requestStaticBinding(Class<T> staticClass) {
        this.requestStaticInjection(new Class[]{staticClass});
    }

    @Override
    public <T> T injectWhenReady(T target) {
        this.objectsToBeInjected.add(target);
        return target;
    }

    public void install(Module binder) {
        this.toInstall.add(binder);
    }

    protected void configure() {
        for (ServicesBinder servicesBinder : this.binders) {
            servicesBinder.bind(this);
        }
        for (BindIfAbsent bindIfAbsent : this.bindIfAbsent) {
            if (this.isBound(bindIfAbsent.serviceInterface, null)) continue;
            this.bindClass(bindIfAbsent.serviceInterface, bindIfAbsent.serviceImplementation);
        }
        for (BindIfAbsentWithQualifier bindIfAbsentWithQualifier : this.bindIfAbsentWithQualifier) {
            if (this.isBound(bindIfAbsentWithQualifier.serviceInterface, bindIfAbsentWithQualifier.qualifier)) continue;
            this.bindClassWithQualifier(bindIfAbsentWithQualifier.serviceInterface, bindIfAbsentWithQualifier.serviceImplementation, bindIfAbsentWithQualifier.qualifier);
        }
        for (Object object : this.objectsToBeInjected) {
            this.requestInjection(object);
        }
        for (Module module : this.toInstall) {
            super.install(module);
        }
    }

    private boolean isBound(Class interfaceService, Class qualifier) {
        return this.boundClass.containsKey(String.valueOf(interfaceService.getName()) + (qualifier == null ? "" : ":" + qualifier.getName()));
    }

    private class BindIfAbsent<T> {
        private final Class<T> serviceInterface;
        private final Class<T> serviceImplementation;

        public BindIfAbsent(Class<T> serviceInterface, Class<T> serviceImplementation) {
            this.serviceInterface = serviceInterface;
            this.serviceImplementation = serviceImplementation;
        }
    }

    private class BindIfAbsentWithQualifier<T> {
        private final Class<T> serviceInterface;
        private final Class<T> serviceImplementation;
        private final Class<?> qualifier;

        public BindIfAbsentWithQualifier(Class<T> serviceInterface, Class<T> serviceImplementation, Class<?> qualifier) {
            this.serviceInterface = serviceInterface;
            this.serviceImplementation = serviceImplementation;
            this.qualifier = qualifier;
        }
    }
}

