/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import com.ur.injection.Builder;
import com.ur.injection.GuiceBinder;
import java.lang.reflect.Type;
import java.util.Set;

class GuiceBuilder
implements Builder {
    private Injector injector;

    public GuiceBuilder(GuiceBinder binder) {
        this.injector = Guice.createInjector((Module[])new Module[]{binder, new AbstractModule(){

            protected void configure() {
                this.bind(Builder.class).toInstance((Object)GuiceBuilder.this);
            }
        }});
    }

    public GuiceBuilder(GuiceBinder binder, GuiceBuilder parentBuilder) {
        this.injector = parentBuilder.injector.createChildInjector(new Module[]{binder});
    }

    @Override
    public <T> T get(Class<T> typeToFetch) {
        if (typeToFetch.equals(Injector.class)) {
            return (T)this.injector;
        }
        return (T)this.injector.getInstance(typeToFetch);
    }

    @Override
    public <T> Set<T> getExtensions(Class<T> type) {
        return (Set)this.injector.getInstance(Key.get(this.setOf(type)));
    }

    private <T> TypeLiteral<Set<T>> setOf(Class<T> type) {
        return TypeLiteral.get((Type)Types.setOf(type));
    }

    @Override
    public void inject(Object service) {
        this.injector.injectMembers(service);
    }
}

