/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.ur.injection.ChainingInterceptor;
import com.ur.lang.ClassUtils;
import com.ur.lang.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class IgnoreCallInterceptor
extends ChainingInterceptor {
    private static ThreadLocal<Boolean> ignoring = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final Class<? extends Annotation> ignoreTag;

    public IgnoreCallInterceptor(Class<? extends Annotation> ignoreTag, MethodInterceptor next) {
        super(next);
        this.ignoreTag = ignoreTag;
    }

    @Override
    protected boolean shouldProcess(MethodInvocation invocation) {
        boolean nonUiThreadOnly = this.isNonUIThreadOnly(invocation);
        if (nonUiThreadOnly && IgnoreCallInterceptor.isUiOrEventThread()) {
            return false;
        }
        return ignoring.get() != false || ClassUtils.hasAnnotation(invocation.getMethod(), this.ignoreTag);
    }

    @Override
    protected Object process(MethodInvocation invocation) throws Throwable {
        if (ignoring.get().booleanValue()) {
            return invocation.proceed();
        }
        try {
            ignoring.set(true);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            ignoring.set(false);
        }
    }

    private static boolean isUiOrEventThread() {
        return SwingUtilities.isEventDispatchThread() || StringUtils.equalsAny(Thread.currentThread().getName(), "AWT-EventQueue-0", "AWT-EventQueue-1", "AWT-EventQueue-2", "Thread-0");
    }

    private boolean isNonUIThreadOnly(MethodInvocation invocation) {
        Annotation annotation = ClassUtils.getAnnotation(invocation.getMethod(), this.ignoreTag);
        if (annotation != null) {
            try {
                Method nonUiThreadOnly = annotation.annotationType().getDeclaredMethod("NonUIThreadOnly", new Class[0]);
                if (nonUiThreadOnly != null) {
                    return (Boolean)nonUiThreadOnly.invoke((Object)annotation, new Object[0]);
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

