/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.google.inject.CreationException;
import com.ur.injection.Builder;
import com.ur.injection.GuiceBindException;
import com.ur.injection.GuiceBinder;
import com.ur.injection.GuiceBuilder;
import com.ur.injection.ServicesBinder;
import java.util.ArrayList;
import java.util.Collection;

public class InjectionFactory {
    public static ModuleAggregator createModuleAggregator(Builder builder) {
        return new ModuleAggregator(builder);
    }

    public static ModuleAggregator createModuleAggregator() {
        return new ModuleAggregator();
    }

    public static class ModuleAggregator {
        Collection<ServicesBinder> binders = new ArrayList<ServicesBinder>();
        private Builder parent;
        private GuiceBuilder builder;

        public ModuleAggregator() {
            this(null);
        }

        public ModuleAggregator(Builder parent) {
            this.parent = parent;
        }

        public void add(ServicesBinder binder) {
            this.binders.add(binder);
        }

        public Builder createBuilder() {
            GuiceBinder binder = new GuiceBinder(this.binders);
            try {
                this.builder = this.parent == null ? new GuiceBuilder(binder) : new GuiceBuilder(binder, (GuiceBuilder)this.parent);
            }
            catch (CreationException ce) {
                if (ce.getCause() instanceof GuiceBindException) {
                    throw (GuiceBindException)ce.getCause();
                }
                throw ce;
            }
            return this.builder;
        }
    }
}

