/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.ur.injection.ChainingInterceptor;
import com.ur.injection.ReferenceValue;
import com.ur.lang.ClassUtils;
import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleConsumer;
import com.ur.reversible.SetProperty;
import com.ur.util.URPropertyUtils;
import com.ur.util.logging.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SetterInterceptor<T>
extends ChainingInterceptor {
    protected final Class<T> targetType;
    protected final Class<? extends Annotation> setterTag;
    protected ReversibleConsumer<T> consumer;
    protected URPropertyUtils propertyUtils;

    public SetterInterceptor(Class<T> targetType, Class<? extends Annotation> setterTag, MethodInterceptor next) {
        super(next);
        this.targetType = targetType;
        this.setterTag = setterTag;
    }

    public void setConsumer(ReversibleConsumer<T> consumer) {
        this.consumer = consumer;
    }

    @Inject
    public void setPropertyUtils(URPropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
    }

    @Override
    protected boolean shouldProcess(MethodInvocation invocation) {
        return ClassUtils.hasAnnotation(invocation.getMethod(), this.setterTag);
    }

    @Override
    protected Object process(MethodInvocation invocation) throws Throwable {
        Object result = null;
        boolean error = false;
        boolean avoidEqualsCheck = invocation.getMethod().isAnnotationPresent(ReferenceValue.class);
        Object target = invocation.getThis();
        Object originalValue = null;
        try {
            originalValue = this.getPropertyValue(invocation, target);
        }
        catch (Exception e) {
            Log.error("Error while processing program node change: " + e.getMessage(), e);
            error = true;
        }
        result = invocation.proceed();
        if (!error) {
            try {
                Object newValue = this.getPropertyValue(invocation, target);
                if (avoidEqualsCheck || !EqualsUtil.equals(originalValue, newValue)) {
                    Reversible<T> reversible = this.makeReversible(invocation, target, originalValue, newValue);
                    boolean uiThreadOnly = this.isUIThreadOnly(invocation);
                    this.checkTargetNotNull(reversible, uiThreadOnly);
                }
            }
            catch (Exception e) {
                Log.error("Error while processing program node change: " + e.getMessage(), e);
            }
        }
        return result;
    }

    private void checkTargetNotNull(Reversible<T> reversible, boolean uiThreadOnly) {
        if (reversible.getTarget() != null && (!uiThreadOnly || SetterInterceptor.isUiOrEventThread())) {
            this.consumer.consume(reversible);
        }
    }

    private static boolean isUiOrEventThread() {
        return SwingUtilities.isEventDispatchThread() || StringUtils.equalsAny(Thread.currentThread().getName(), "AWT-EventQueue-0", "AWT-EventQueue-1", "AWT-EventQueue-2", "Thread-0");
    }

    private boolean isUIThreadOnly(MethodInvocation invocation) {
        Annotation annotation = ClassUtils.getAnnotation(invocation.getMethod(), this.setterTag);
        if (annotation != null) {
            try {
                Method uiThreadOnly = annotation.annotationType().getDeclaredMethod("UIThreadOnly", new Class[0]);
                if (uiThreadOnly != null) {
                    return (Boolean)uiThreadOnly.invoke((Object)annotation, new Object[0]);
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected Reversible<T> makeReversible(MethodInvocation invocation, Object target, Object originalValue, Object newValue) throws Throwable {
        Method invoked = invocation.getMethod();
        String propertyName = this.propertyUtils.getPropertyName(invoked);
        Object index = this.getIndex(invocation);
        String longPropertyName = this.propertyUtils.getLongPropertyName(target, propertyName, index);
        Method setter = this.propertyUtils.getWriteMethod(target, propertyName, index);
        return new SetProperty<T, Object>(this.targetType, target, longPropertyName, setter, index, originalValue, newValue);
    }

    protected Object getPropertyValue(MethodInvocation invocation, Object target) throws Throwable {
        Object[] arguments = invocation.getArguments();
        String propertyName = this.propertyUtils.getPropertyName(invocation.getMethod());
        if (propertyName == null) {
            String methodName = invocation.getMethod().getName();
            throw new IllegalArgumentException("Called for non-setter method \"" + methodName + "\".");
        }
        Object index = null;
        if (arguments.length > 1) {
            index = arguments[0];
        }
        return this.propertyUtils.getProperty(target, propertyName, index);
    }

    protected Object getIndex(MethodInvocation invocation) {
        Object[] arguments = invocation.getArguments();
        if (arguments.length == 0 || arguments.length > 2) {
            String methodName = invocation.getMethod().getName();
            throw new IllegalArgumentException("Can only handle setter methods with one or two arguments. Called for method \"" + methodName + "\" with " + arguments.length + " arguments.");
        }
        if (arguments.length == 2) {
            return arguments[0];
        }
        return null;
    }
}

