/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.ur.injection.ChainingInterceptor;
import com.ur.injection.ReferenceValue;
import com.ur.lang.ClassUtils;
import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleConsumer;
import com.ur.reversible.SubstituteValues;
import com.ur.reversible.SubstitutionChange;
import com.ur.util.logging.Log;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SubstituteInterceptor<T>
extends ChainingInterceptor {
    protected final Class<T> targetType;
    protected ReversibleConsumer<T> consumer;

    public SubstituteInterceptor(Class<T> targetType, MethodInterceptor next) {
        super(next);
        this.targetType = targetType;
    }

    public void setConsumer(ReversibleConsumer<T> consumer) {
        this.consumer = consumer;
    }

    @Override
    protected boolean shouldProcess(MethodInvocation invocation) {
        return ClassUtils.hasAnnotation(invocation.getMethod(), SubstitutionChange.class);
    }

    @Override
    protected Object process(MethodInvocation invocation) throws Throwable {
        Object result = null;
        boolean error = false;
        boolean avoidEqualsCheck = invocation.getMethod().isAnnotationPresent(ReferenceValue.class);
        Object target = invocation.getThis();
        Object originalValue = this.getArgument(invocation, 0);
        Object newValue = this.getArgument(invocation, 1);
        try {
            result = invocation.proceed();
        }
        catch (Exception exception) {
            error = true;
        }
        if (!error) {
            try {
                if (avoidEqualsCheck || !EqualsUtil.equals(originalValue, newValue)) {
                    SubstitutionChange programEntitiesChange = invocation.getMethod().getAnnotation(SubstitutionChange.class);
                    Reversible<T> reversible = this.makeReversible(invocation, target, originalValue, newValue, programEntitiesChange.method());
                    boolean uiThreadOnly = this.isUIThreadOnly(invocation);
                    if (reversible.getTarget() != null && (!uiThreadOnly || SubstituteInterceptor.isUiOrEventThread())) {
                        this.consumer.consume(reversible);
                    }
                }
            }
            catch (Exception e) {
                Log.error("Error while processing program node change: " + e.getMessage(), e);
            }
        }
        return result;
    }

    private static boolean isUiOrEventThread() {
        return SwingUtilities.isEventDispatchThread() || StringUtils.equalsAny(Thread.currentThread().getName(), "AWT-EventQueue-0", "AWT-EventQueue-1", "AWT-EventQueue-2", "Thread-0");
    }

    private boolean isUIThreadOnly(MethodInvocation invocation) {
        SubstitutionChange annotation = ClassUtils.getAnnotation(invocation.getMethod(), SubstitutionChange.class);
        if (annotation != null) {
            try {
                Method uiThreadOnly = annotation.annotationType().getDeclaredMethod("UIThreadOnly", new Class[0]);
                if (uiThreadOnly != null) {
                    return (Boolean)uiThreadOnly.invoke((Object)annotation, new Object[0]);
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected Reversible<T> makeReversible(MethodInvocation invocation, Object target, Object originalValue, Object newValue, String methodName) throws Throwable {
        Method substituteMethod = invocation.getMethod();
        return new SubstituteValues<T, Object>(this.targetType, target, substituteMethod, originalValue, newValue, methodName);
    }

    protected Object getArgument(MethodInvocation invocation, int index) {
        Object[] arguments = invocation.getArguments();
        if (arguments.length != 2 || index != 0 && index != 1) {
            String methodName = invocation.getMethod().getName();
            throw new IllegalArgumentException("Can only handle substitute methods with two arguments. Called for method \"" + methodName + "\" with " + arguments.length + " arguments.");
        }
        return arguments[index];
    }
}

