/*
 * Decompiled with CFR 0.152.
 */
package com.ur.injection;

import com.google.inject.Inject;
import com.ur.exception.CustomUncaughtExceptionHandler;
import com.ur.injection.ChainingInterceptor;
import com.ur.lang.ClassUtils;
import com.ur.reversible.ReversibleConsumer;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ThrowIfNonCompoundChangeInterceptor<T>
extends ChainingInterceptor {
    private static ThreadLocal<Boolean> ignoring = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> isThrowing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private final Class<? extends Annotation> ignoreTag;
    private ReversibleConsumer<T> consumer;
    private CustomUncaughtExceptionHandler exceptionHandler = new NullUncaughtExceptionHandler();

    public ThrowIfNonCompoundChangeInterceptor(Class<? extends Annotation> ignoreTag, MethodInterceptor next) {
        super(next);
        this.ignoreTag = ignoreTag;
    }

    @Inject(optional=true)
    public void setCustomExceptionHandler(CustomUncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setConsumer(ReversibleConsumer<T> consumer) {
        this.consumer = consumer;
    }

    ReversibleConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    protected boolean shouldProcess(MethodInvocation invocation) {
        if (ignoring.get().booleanValue()) {
            return true;
        }
        boolean isMethodAnnotatedWithTag = this.isMethodAnnotatedWithTag(invocation);
        if (!isMethodAnnotatedWithTag) {
            return false;
        }
        if (!this.isInsideACompoundProgramChange(this.consumer)) {
            if (isThrowing.get().booleanValue()) {
                IllegalStateException illegalStateException = new IllegalStateException("Modifications to program tree and/or data model must be inside a 'UndoableChange' scope. Use 'UndoRedoManager' to group undoable changes.");
                this.exceptionHandler.setStackTraceClassesForThrowable(this.getClassContext(), illegalStateException);
                throw illegalStateException;
            }
            return true;
        }
        return false;
    }

    private boolean isMethodAnnotatedWithTag(MethodInvocation invocation) {
        return ClassUtils.hasAnnotation(invocation.getMethod(), this.ignoreTag);
    }

    boolean isInsideACompoundProgramChange(ReversibleConsumer<T> consumer) {
        return consumer.isSequenceStarted();
    }

    @Override
    protected Object process(MethodInvocation invocation) throws Throwable {
        if (ignoring.get().booleanValue()) {
            return ThrowIfNonCompoundChangeInterceptor.executeProceed(invocation);
        }
        try {
            ignoring.set(true);
            Object object = ThrowIfNonCompoundChangeInterceptor.executeProceed(invocation);
            return object;
        }
        finally {
            ignoring.set(false);
        }
    }

    public static void setIsThrowing(boolean isThrowing) {
        ThrowIfNonCompoundChangeInterceptor.isThrowing.set(isThrowing);
    }

    private static Object executeProceed(MethodInvocation invocation) throws Throwable {
        return invocation.proceed();
    }

    private static class NullUncaughtExceptionHandler
    implements CustomUncaughtExceptionHandler {
        private NullUncaughtExceptionHandler() {
        }

        @Override
        public void setStackTraceClassesForThrowable(Class[] classes, Throwable throwable) {
        }
    }
}

