/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class BijectiveEnumMap<E extends Enum<E>, V> {
    private boolean sealed = false;
    private final Class<E> enumType;
    private final Map<E, V> enumToValue;
    private final Map<V, E> valueToEnum;

    public BijectiveEnumMap(Class<E> enumType) {
        this.enumType = enumType;
        this.enumToValue = new EnumMap(enumType);
        this.valueToEnum = new HashMap<V, E>();
    }

    public BijectiveEnumMap<E, V> put(E key, V value) {
        if (this.sealed) {
            throw new IllegalStateException("Attempt to modify a sealed map.");
        }
        if (this.enumToValue.get(key) != null) {
            throw new IllegalStateException("Only one value per enum constant allowed.");
        }
        if (this.valueToEnum.get(value) != null) {
            throw new IllegalStateException("Each enum constant must have a different associated value.");
        }
        this.enumToValue.put(key, value);
        this.valueToEnum.put(value, key);
        return this;
    }

    public BijectiveEnumMap<E, V> seal() {
        this.sealed = true;
        Enum[] enumArray = (Enum[])this.enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum each = enumArray[n2];
            if (this.enumToValue.get(each) == null) {
                throw new IllegalStateException("Value for enum missing.");
            }
            ++n2;
        }
        return this;
    }

    public V getValue(E key) {
        if (key == null) {
            return null;
        }
        V value = this.enumToValue.get(key);
        if (value == null) {
            throw new IllegalStateException("Value for key is missing.");
        }
        return value;
    }

    public E getKey(V value) {
        if (value == null) {
            return null;
        }
        Enum key = (Enum)this.valueToEnum.get(value);
        if (key == null) {
            throw new IllegalStateException("Key for value has not been registered.");
        }
        return (E)key;
    }
}

