/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import com.ur.lang.EndianConverter;
import java.nio.ByteBuffer;

public class CRCUtils {
    public static final int CRC_HASH = -1;
    private static final int[] nibbleLookupTable;
    private final EndianConverter converter = new EndianConverter.LittleEndian();

    static {
        int[] nArray = new int[16];
        nArray[1] = 79764919;
        nArray[2] = 159529838;
        nArray[3] = 222504665;
        nArray[4] = 319059676;
        nArray[5] = 398814059;
        nArray[6] = 445009330;
        nArray[7] = 507990021;
        nArray[8] = 638119352;
        nArray[9] = 583659535;
        nArray[10] = 797628118;
        nArray[11] = 726387553;
        nArray[12] = 890018660;
        nArray[13] = 835552979;
        nArray[14] = 1015980042;
        nArray[15] = 944750013;
        nibbleLookupTable = nArray;
    }

    public int crc32Fast(int checksum, ByteBuffer buffer) {
        int i = 0;
        while (i < buffer.capacity()) {
            int size = buffer.capacity() - i;
            if (size > 3) {
                int chunk = this.converter.convert(buffer.getInt(i));
                checksum = this.crc32Fast(checksum, chunk);
            } else {
                byte[] dst = new byte[4];
                int j = 0;
                while (j < size) {
                    dst[j] = buffer.get(i + j);
                    ++j;
                }
                int remaining = this.converter.convert(ByteBuffer.allocate(4).put(dst).getInt(0));
                checksum = this.crc32Fast(checksum, remaining);
            }
            i += 4;
        }
        return checksum;
    }

    public int crc32Fast(int checksum, int chunk) {
        checksum ^= chunk;
        checksum = this.getChecksumMake(checksum);
        checksum = this.getChecksumMake(checksum);
        checksum = this.getChecksumMake(checksum);
        checksum = this.getChecksumMake(checksum);
        checksum = this.getChecksumMake(checksum);
        checksum = this.getChecksumMake(checksum);
        checksum = this.getChecksumMake(checksum);
        checksum = this.getChecksumMake(checksum);
        return checksum;
    }

    private int getChecksumMake(int checksum) {
        return checksum << 4 ^ nibbleLookupTable[this.lastFourDigits(checksum)];
    }

    public int lastFourDigits(int checksum) {
        int tableLookup = checksum < 0 ? 8 : 0;
        tableLookup |= (checksum & 0x40000000) == 0x40000000 ? 4 : 0;
        tableLookup |= (checksum & 0x20000000) == 0x20000000 ? 2 : 0;
        return tableLookup |= (checksum & 0x10000000) == 0x10000000 ? 1 : 0;
    }
}

