/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import com.ur.util.logging.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ClassUtils {
    public static <T> Collection<T> getInstancesByName(String ... namedClasses) throws InstantiationException, IllegalAccessException {
        Collection<Class<T>> classesByName = ClassUtils.getClassesByName(namedClasses);
        return ClassUtils.instantiateClasses(classesByName);
    }

    public static <T> Collection<Class<T>> getClassesByName(String ... namedClasses) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        String[] stringArray = namedClasses;
        int n = namedClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            try {
                result.add(Class.forName(each));
            }
            catch (ClassNotFoundException ex) {
                Log.warning("Failed to find class: " + each, ex);
            }
            ++n2;
        }
        return result;
    }

    public static <T> Collection<T> instantiateClasses(Iterable<Class<T>> classes) throws InstantiationException, IllegalAccessException {
        ArrayList<T> result = new ArrayList<T>();
        for (Class<T> each : classes) {
            result.add(each.newInstance());
        }
        return result;
    }

    public static boolean isInstanceOfAny(Object unknownInstance, Class<?> ... classes) {
        return ClassUtils.isInstanceOfAny(unknownInstance, Arrays.asList(classes));
    }

    public static boolean isInstanceOfAny(Object unknownInstance, Iterable<Class<?>> classes) {
        for (Class<?> each : classes) {
            if (!each.isInstance(unknownInstance)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFromAny(Class<?> unknownType, Class<?> ... classes) {
        return ClassUtils.isAssignableFromAny(unknownType, Arrays.asList(classes));
    }

    public static boolean isAssignableFromAny(Class<?> unknownType, Collection<Class<?>> classes) {
        for (Class<?> each : classes) {
            if (!each.isAssignableFrom(unknownType)) continue;
            return true;
        }
        return false;
    }

    public static String getClassName(Object subject) {
        return subject == null ? "unknown" : subject.getClass().getName();
    }

    public static boolean hasAnnotation(Object object, Class<? extends Annotation> annotationType) {
        return ClassUtils.getAnnotation(object, annotationType) != null;
    }

    public static <A extends Annotation> A getAnnotation(Object object, Class<A> annotationType) {
        Class<?> element = null;
        if (object instanceof AnnotatedElement) {
            element = (Class<?>)object;
        } else if (object != null) {
            element = object.getClass();
        }
        return element == null ? null : (A)element.getAnnotation((Class<?>)annotationType);
    }

    public static Class<?> getClass(Object instance) {
        if (instance == null) {
            return null;
        }
        return instance.getClass();
    }
}

