/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class DecimalFormatFactory {
    private DecimalFormatFactory() {
    }

    public static DecimalFormat createHalfEvenDecimalFormat(String pattern) {
        return DecimalFormatFactory.createDecimalFormat(pattern, RoundingMode.HALF_EVEN);
    }

    public static DecimalFormat createHalfUpDecimalFormat(String pattern) {
        return DecimalFormatFactory.createDecimalFormat(pattern, RoundingMode.HALF_UP);
    }

    public static DecimalFormat createDecimalFormat(String pattern, RoundingMode roundingMode) {
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        decimalFormat.setRoundingMode(roundingMode);
        DecimalFormatFactory.applyDefaultMinusSignsAndNegativePrefix(decimalFormat);
        return decimalFormat;
    }

    public static DecimalFormat createHalfEvenDecimalFormatWithLocale(String pattern, Locale locale) {
        DecimalFormat decimalFormat = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
        DecimalFormatFactory.applyDefaultMinusSignsAndNegativePrefix(decimalFormat);
        return decimalFormat;
    }

    public static String getNegativePrefixForCurrentLocale() {
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        return numberFormat.getNegativePrefix();
    }

    public static void applyDefaultMinusSignsAndNegativePrefix(DecimalFormat decimalFormat) {
        decimalFormat.getDecimalFormatSymbols().setMinusSign(DecimalFormatFactory.getDefaultMinusSign());
        decimalFormat.setNegativePrefix(DecimalFormatFactory.getDefaultNegativePrefix());
    }

    public static char getDefaultMinusSign() {
        return new DecimalFormatSymbols(Locale.ENGLISH).getMinusSign();
    }

    public static String getDefaultNegativePrefix() {
        char defaultMinusSign = DecimalFormatFactory.getDefaultMinusSign();
        return String.valueOf(defaultMinusSign);
    }
}

