/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import com.ur.lang.ClassUtils;
import com.ur.lang.StringUtils;
import com.ur.util.ArrayUtils;
import java.util.Arrays;

public class Defense {
    public static <T> T isNull(T subject) {
        return Defense.isNull(subject, "Expect subject of type %class% to be null");
    }

    public static <T> T isNull(T subject, String message) {
        if (subject != null) {
            throw new DefenseCheckException(subject, message);
        }
        return subject;
    }

    public static <T> T notNull(T subject) {
        return Defense.notNull(subject, "Expect subject to NOT be null");
    }

    public static <T> T notNull(T subject, String message) {
        if (subject == null) {
            throw new DefenseCheckException(subject, message);
        }
        return subject;
    }

    public static String notNullOrEmpty(String subject) {
        return Defense.notNullOrEmpty(subject, "Expect String to NOT be empty");
    }

    public static String notNullOrEmpty(String subject, String message) {
        Defense.notNull(subject, message);
        Defense.isNotEmpty(subject, message);
        return subject;
    }

    public static <T> T isLength(T subject, int expectedLength) {
        int actualLength = ArrayUtils.sizeOf(subject);
        if (actualLength != expectedLength) {
            throw new DefenseCheckException(subject, "Expected %class% to have length " + expectedLength + ", but was " + actualLength);
        }
        return subject;
    }

    public static <T> T isLength(T subject, int expectedLength, String message) {
        if (ArrayUtils.sizeOf(subject) != expectedLength) {
            throw new DefenseCheckException(subject, message);
        }
        return subject;
    }

    public static void sameLength(Object first, Object second, String message) {
        if (ArrayUtils.sizeOf(first) != ArrayUtils.sizeOf(second)) {
            throw new DefenseCheckException(first, message);
        }
    }

    public static <T> T isOneOf(T subject, T ... options) {
        T[] TArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            T each = TArray[n2];
            if (subject.equals(each)) {
                return subject;
            }
            ++n2;
        }
        throw new DefenseCheckException(subject, "Expected subject [%instance%] to be contained in " + Arrays.toString(options) + ", but no match found.");
    }

    public static <T> T isNotEmpty(T subject, String message) {
        if (ArrayUtils.sizeOf(subject) <= 0) {
            throw new DefenseCheckException(subject, message);
        }
        return subject;
    }

    public static <T> T isInstanceOf(T subject, Class<? extends Object> expectedTypeOfSubject) {
        return Defense.isInstanceOf(subject, expectedTypeOfSubject, "Expected subject [%instance%] to be of type " + expectedTypeOfSubject.getName() + ", but was %class%");
    }

    public static <T> T isInstanceOf(T subject, Class<? extends Object> expectedTypeOfSubject, String message) {
        Defense.notNull(subject);
        if (!expectedTypeOfSubject.isInstance(subject)) {
            throw new DefenseCheckException(subject, message);
        }
        return subject;
    }

    public static void isCondition(boolean condition, String message) {
        if (!condition) {
            throw new DefenseCheckException(message);
        }
    }

    public static final class DefenseCheckException
    extends AssertionError {
        private final String message;

        public DefenseCheckException(Object subject, String message) {
            super(subject);
            message = message.replaceAll("\\%instance\\%", StringUtils.toString(subject));
            this.message = message = message.replaceAll("\\%class\\%", ClassUtils.getClassName(subject));
        }

        public DefenseCheckException(String message) {
            super((Object)message);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

