/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface EndianConverter {
    public static final int wordSize = 4;
    public static final int CHAR_SIZE = 2;

    public byte convert(boolean var1);

    public int convert(int var1);

    @Deprecated
    public float convert(DataInput var1) throws IOException;

    @Deprecated
    public ByteBuffer convert(ByteBuffer var1, float var2);

    public float getFloat(DataInput var1) throws IOException;

    public ByteBuffer putFloat(ByteBuffer var1, float var2);

    public int getUnsignedShort(DataInput var1) throws IOException;

    public ByteBuffer putUnsignedShort(ByteBuffer var1, int var2);

    public static class BigEndian
    implements EndianConverter {
        @Override
        public byte convert(boolean value) {
            return (byte)(value ? 1 : 0);
        }

        @Override
        public int convert(int value) {
            return value;
        }

        @Override
        public float convert(DataInput stream) throws IOException {
            float f = stream.readFloat();
            return f;
        }

        @Override
        public ByteBuffer convert(ByteBuffer putBuffer, float value) {
            return putBuffer.putFloat(value);
        }

        @Override
        public float getFloat(DataInput stream) throws IOException {
            return this.convert(stream);
        }

        @Override
        public ByteBuffer putFloat(ByteBuffer putBuffer, float value) {
            return this.convert(putBuffer, value);
        }

        @Override
        public int getUnsignedShort(DataInput stream) throws IOException {
            return stream.readChar();
        }

        @Override
        public ByteBuffer putUnsignedShort(ByteBuffer putBuffer, int value) {
            return putBuffer.putChar((char)value);
        }
    }

    public static class LittleEndian
    implements EndianConverter {
        @Override
        public byte convert(boolean value) {
            return (byte)(value ? 1 : 0);
        }

        @Override
        public int convert(int value) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            return buffer.order(ByteOrder.BIG_ENDIAN).putInt(0, value).order(ByteOrder.LITTLE_ENDIAN).getInt(0);
        }

        @Override
        public float convert(DataInput stream) throws IOException {
            byte[] data = new byte[4];
            stream.readFully(data);
            return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getFloat(0);
        }

        @Override
        public ByteBuffer convert(ByteBuffer putBuffer, float value) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.order(ByteOrder.LITTLE_ENDIAN).putFloat(0, value);
            return putBuffer.put(buffer);
        }

        @Override
        public float getFloat(DataInput stream) throws IOException {
            return this.convert(stream);
        }

        @Override
        public ByteBuffer putFloat(ByteBuffer putBuffer, float value) {
            return this.convert(putBuffer, value);
        }

        @Override
        public int getUnsignedShort(DataInput stream) throws IOException {
            byte[] data = new byte[2];
            stream.readFully(data);
            return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getChar(0);
        }

        @Override
        public ByteBuffer putUnsignedShort(ByteBuffer putBuffer, int value) {
            ByteBuffer buffer = ByteBuffer.allocate(2);
            buffer.order(ByteOrder.LITTLE_ENDIAN).putChar(0, (char)value);
            return putBuffer.put(buffer);
        }
    }
}

