/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public class EnumUtils {
    public static <T extends Enum<T>> T getEnum(Class<T> enumType, String argument) {
        Enum[] enumArray = (Enum[])enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum each = enumArray[n2];
            if (each.name().equalsIgnoreCase(argument)) {
                return (T)each;
            }
            ++n2;
        }
        return null;
    }

    public static <X extends Enum<X>> Map<X, String> createEnumResourceValueMap(Class<X> c, String resourceValue) {
        EnumMap<X, String> map = new EnumMap<X, String>(c);
        EnumSet<Enum> allEnums = EnumSet.allOf(c);
        String[] allValues = resourceValue.split(";");
        if (allEnums.size() != allValues.length) {
            throw new RuntimeException("Invalid resource values. Lookup for " + c.getSimpleName() + " should have " + allEnums.size() + " values but has " + allValues.length);
        }
        int i = 0;
        for (Enum e : allEnums) {
            map.put(e, allValues[i++]);
        }
        return map;
    }

    public static String getEnumResourceValue(Enum e, String resourceValue) {
        return resourceValue.split(";")[e.ordinal()];
    }
}

