/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import com.ur.lang.Register;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;

public class EqualsBuilder
extends org.apache.commons.lang3.builder.EqualsBuilder {
    private double delta;

    public EqualsBuilder(double delta) {
        this.delta = delta;
    }

    public org.apache.commons.lang3.builder.EqualsBuilder append(double lhs, double rhs) {
        if (!this.isEquals()) {
            return this;
        }
        if (Math.abs(lhs - rhs) > this.delta) {
            this.setEquals(false);
        }
        return this;
    }

    public org.apache.commons.lang3.builder.EqualsBuilder append(double[] lhs, double[] rhs) {
        if (!this.isEquals()) {
            return this;
        }
        int i = 0;
        while (i < lhs.length) {
            if (Math.abs(lhs[i] - rhs[i]) > this.delta) {
                this.setEquals(false);
            }
            ++i;
        }
        return this;
    }

    public EqualsBuilder append(Object lhs, Object rhs) {
        if (!this.isEquals() || lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        Class<?> lhsClass = lhs.getClass();
        if (lhsClass.equals(Double.class)) {
            Double lhsDouble = (Double)lhs;
            Double rhsDouble = (Double)rhs;
            this.append(lhsDouble, rhsDouble);
        } else if (!lhsClass.isArray()) {
            this.setEquals(lhs.equals(rhs));
        } else if (lhs.getClass() != rhs.getClass()) {
            this.setEquals(false);
        } else if (lhs instanceof long[]) {
            this.append((long[])lhs, (long[])rhs);
        } else if (lhs instanceof int[]) {
            this.append((int[])lhs, (int[])rhs);
        } else if (lhs instanceof short[]) {
            this.append((short[])lhs, (short[])rhs);
        } else if (lhs instanceof char[]) {
            this.append((char[])lhs, (char[])rhs);
        } else if (lhs instanceof byte[]) {
            this.append((byte[])lhs, (byte[])rhs);
        } else if (lhs instanceof double[]) {
            this.append((double[])lhs, (double[])rhs);
        } else if (lhs instanceof float[]) {
            this.append((float[])lhs, (float[])rhs);
        } else if (lhs instanceof boolean[]) {
            this.append((boolean[])lhs, (boolean[])rhs);
        } else {
            this.append((Object[])lhs, (Object[])rhs);
        }
        return this;
    }

    public boolean isEquals(Object lhs, Object rhs) {
        Class<?> testClass;
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        Class<?> lhsClass = lhs.getClass();
        Class<?> rhsClass = rhs.getClass();
        if (lhsClass.isInstance(rhs)) {
            testClass = lhsClass;
            if (!rhsClass.isInstance(lhs)) {
                testClass = rhsClass;
            }
        } else if (rhsClass.isInstance(lhs)) {
            testClass = rhsClass;
            if (!lhsClass.isInstance(rhs)) {
                testClass = lhsClass;
            }
        } else {
            return false;
        }
        try {
            EqualsBuilder.reflectionAppend(lhs, rhs, testClass, this, false, new String[0]);
            while (testClass.getSuperclass() != null) {
                testClass = testClass.getSuperclass();
                EqualsBuilder.reflectionAppend(lhs, rhs, testClass, this, false, new String[0]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return this.isEquals();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void reflectionAppend(Object lhs, Object rhs, Class<?> clazz, EqualsBuilder builder, boolean useTransients, String[] excludeFields) {
        Register register = new Register();
        if (register.isRegistered(lhs, rhs)) {
            return;
        }
        try {
            block8: {
                int i;
                AccessibleObject[] fields;
                block7: {
                    register.register(lhs, rhs);
                    fields = clazz.getDeclaredFields();
                    AccessibleObject.setAccessible(fields, true);
                    i = 0;
                    if (!true) break block7;
                    if (i >= fields.length) return;
                    if (!builder.isEquals()) break block8;
                }
                do {
                    AccessibleObject f;
                    if (!(ArrayUtils.contains((Object[])excludeFields, (Object)((Field)(f = fields[i])).getName()) || ((Field)f).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers()))) {
                        EqualsBuilder.tryToBuild(lhs, rhs, builder, (Field)f);
                    }
                    ++i;
                    if (i >= fields.length) return;
                } while (builder.isEquals());
            }
            return;
        }
        finally {
            register.unregister(lhs, rhs);
        }
    }

    private static void tryToBuild(Object lhs, Object rhs, EqualsBuilder builder, Field f) {
        try {
            builder.append(f.get(lhs), f.get(rhs));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError("Unexpected IllegalAccessException");
        }
    }
}

