/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

public class EqualsUtil {
    private EqualsUtil() {
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean notEquals(Object a, Object b) {
        return !EqualsUtil.equals(a, b);
    }

    public static boolean notEquals(double a, double b, double delta) {
        return !EqualsUtil.equals(a, b, delta);
    }

    public static boolean equalsOneOf(int a, int[] oneOf) {
        int[] nArray = oneOf;
        int n = oneOf.length;
        int n2 = 0;
        while (n2 < n) {
            int each = nArray[n2];
            if (a == each) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean equalsOneOf(char a, char[] oneOf) {
        char[] cArray = oneOf;
        int n = oneOf.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            if (a == each) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T, S extends T> boolean equalsOneOf(T a, S ... oneOf) {
        S[] SArray = oneOf;
        int n = oneOf.length;
        int n2 = 0;
        while (n2 < n) {
            S each = SArray[n2];
            if (EqualsUtil.equals(a, each)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T, S extends T> boolean notEqualsOneOf(T a, S ... oneOf) {
        return !EqualsUtil.equalsOneOf(a, oneOf);
    }

    public static boolean equals(double[] a, double[] b, double delta) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!EqualsUtil.equals(a[i], b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(double a, double b, double delta) {
        if (Double.compare(a, b) == 0) {
            return true;
        }
        return Math.abs(a - b) <= delta;
    }

    public static int compare(Comparable a, Comparable b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? 1 : -1;
        }
        return a.compareTo(b);
    }

    public static boolean equalsType(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.getClass().equals(b.getClass());
        }
        return false;
    }
}

