/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import com.ur.lang.Register;
import com.ur.util.logging.Log;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.commons.lang3.ArrayUtils;

public class HashCodeBuilder
extends org.apache.commons.lang3.builder.HashCodeBuilder {
    private static Field total;
    private static Field constant;
    private int delta;

    static {
        try {
            total = org.apache.commons.lang3.builder.HashCodeBuilder.class.getField("iTotal");
            total.setAccessible(true);
            constant = org.apache.commons.lang3.builder.HashCodeBuilder.class.getField("iConstant");
            constant.setAccessible(true);
        }
        catch (Exception exception) {}
    }

    public HashCodeBuilder(int precision) {
        super(13, 17);
        this.delta = precision;
    }

    public org.apache.commons.lang3.builder.HashCodeBuilder append(double value) {
        BigDecimal bigValue = null;
        if (value < 1.0) {
            bigValue = new BigDecimal(1.0 + value);
        } else {
            try {
                bigValue = new BigDecimal(value);
            }
            catch (Exception exception) {
                this.append(Double.doubleToLongBits(value));
                return this;
            }
        }
        int length = String.valueOf(bigValue.intValue()).length();
        double roundedValue = bigValue.round(new MathContext(this.delta + length, RoundingMode.CEILING)).doubleValue();
        this.append(Double.doubleToLongBits(roundedValue));
        return this;
    }

    public org.apache.commons.lang3.builder.HashCodeBuilder append(double[] array) {
        if (array == null) {
            this.setInt(total, this.getInt(total) * this.getInt(constant));
        } else {
            double[] dArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                double element = dArray[n2];
                this.append(element);
                ++n2;
            }
        }
        return this;
    }

    private void setInt(Field field, int value) {
        try {
            field.setInt((Object)this, value);
        }
        catch (Exception exception) {
            Log.warning("Failed to update the hash with double value");
        }
    }

    private int getInt(Field field) {
        try {
            return field.getInt((Object)this);
        }
        catch (Exception exception) {
            Log.warning("Failed to update the hash with double value");
            return 0;
        }
    }

    public int reflectHashCode(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The object to build a hash code for must not be null");
        }
        Class<?> clazz = object.getClass();
        HashCodeBuilder.reflectionAppend(object, clazz, this, false, new String[0]);
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            HashCodeBuilder.reflectionAppend(object, clazz, this, false, new String[0]);
        }
        return this.toHashCode();
    }

    private static void reflectionAppend(Object object, Class<?> clazz, HashCodeBuilder builder, boolean useTransients, String[] excludeFields) {
        Register register = new Register();
        if (register.isRegistered(object, null)) {
            return;
        }
        try {
            register.register(object, null);
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            AccessibleObject[] accessibleObjectArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                AccessibleObject field = accessibleObjectArray[n2];
                if (!(ArrayUtils.contains((Object[])excludeFields, (Object)((Field)field).getName()) || ((Field)field).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers()))) {
                    try {
                        Object fieldValue = ((Field)field).get(object);
                        if (fieldValue instanceof Double) {
                            Double value = (Double)fieldValue;
                            builder.append(value);
                        } else {
                            builder.append(fieldValue);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new InternalError("Unexpected IllegalAccessException");
                    }
                }
                ++n2;
            }
        }
        finally {
            register.unregister(object, null);
        }
    }
}

