/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapOfIdentityLists<K, V> {
    private final List<V> nullKeyCollection = new CopyOnWriteArrayList<V>();
    private final Map<K, List<V>> keyToCollections = new ConcurrentHashMap<K, List<V>>();

    public void put(K key, V value) {
        if (key == null) {
            this.nullKeyCollection.add(value);
            return;
        }
        if (!this.keyToCollections.containsKey(key)) {
            this.keyToCollections.put(key, new CopyOnWriteArrayList());
        }
        this.keyToCollections.get(key).add(value);
    }

    public List<V> get(K key) {
        if (key == null) {
            return new ArrayList<V>(this.nullKeyCollection);
        }
        List<V> values = this.keyToCollections.get(key);
        if (values == null) {
            return Collections.emptyList();
        }
        return new ArrayList<V>(values);
    }

    public boolean contains(K key, V value) {
        List<V> collection;
        List<V> list = collection = key == null ? this.nullKeyCollection : this.keyToCollections.get(key);
        if (collection != null) {
            for (V each : collection) {
                if (each != value) continue;
                return true;
            }
        }
        return false;
    }

    public K findKey(V value) {
        for (K each : this.keyToCollections.keySet()) {
            if (!this.contains(each, value)) continue;
            return each;
        }
        return null;
    }

    public boolean remove(K key, V value) {
        List<V> collection;
        boolean result = false;
        List<V> list = collection = key == null ? this.nullKeyCollection : this.keyToCollections.get(key);
        if (collection != null) {
            result = this.removeReferencedFromCollection(collection, value);
            if (key != null && collection.isEmpty()) {
                this.keyToCollections.remove(key);
            }
        }
        return result;
    }

    private boolean removeReferencedFromCollection(List<V> collection, V value) {
        boolean result = false;
        int i = 0;
        while (i < collection.size()) {
            if (collection.get(i) == value) {
                collection.remove(i);
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public Set<K> keySet() {
        HashSet<K> result = new HashSet<K>(this.keyToCollections.keySet());
        if (!this.nullKeyCollection.isEmpty()) {
            result.add(null);
        }
        return result;
    }

    public List<V> allValues() {
        ArrayList<V> result = new ArrayList<V>();
        result.addAll(this.nullKeyCollection);
        for (K each : this.keySet()) {
            List<V> collection = this.keyToCollections.get(each);
            if (collection == null) continue;
            result.addAll(collection);
        }
        return result;
    }

    public void clear() {
        this.nullKeyCollection.clear();
        this.keyToCollections.clear();
    }
}

