/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import com.ur.lang.PrimitiveUtils;
import java.util.Set;

public class NamingUtils {
    public static final int MAXIMUM_LENGTH_OF_NAME = 15;
    public static final int MAXIMUM_LENGTH_OF_FREE_NAME = 32;

    public static String stripNumbersOffEndOfName(String originalName) {
        if (!NamingUtils.hasAppendedNumber(originalName)) {
            return originalName;
        }
        String result = originalName;
        while (Character.isDigit(result.charAt(result.length() - 1))) {
            result = result.substring(0, result.length() - 1);
        }
        result = NamingUtils.stripUnderscoreOffEndOfName(result);
        return result;
    }

    public static String stripUnderscoreOffEndOfName(String originalName) {
        while (originalName.endsWith("_")) {
            originalName = originalName.substring(0, originalName.length() - 1);
        }
        return originalName;
    }

    public static String truncateNameToSupportNumbering(String originalName) {
        return NamingUtils.truncateName(originalName, 13);
    }

    public static String truncateName(String originalName) {
        return NamingUtils.truncateName(originalName, 15);
    }

    public static String truncateName(String originalName, int length) {
        if (originalName != null && originalName.length() > length) {
            originalName = originalName.substring(0, length);
        }
        return originalName;
    }

    public static String convertToJavaValidName(String candidateName) {
        if (candidateName == null) {
            return null;
        }
        candidateName = candidateName.trim();
        StringBuilder nc = new StringBuilder();
        boolean isFirstCharacter = true;
        int i = 0;
        while (i < candidateName.length()) {
            Character c = Character.valueOf(candidateName.charAt(i));
            if (isFirstCharacter) {
                if (Character.isDigit(c.charValue())) {
                    nc.append('a');
                    nc.append(c);
                } else if (Character.isLetter(c.charValue())) {
                    nc.append(c);
                } else if (c.charValue() == '_' || c.charValue() == '-') {
                    nc.append('_');
                } else {
                    nc.append('x');
                }
                isFirstCharacter = false;
            } else if (c.charValue() == ' ' || c.charValue() == '-' || c.charValue() == '_') {
                nc.append('_');
            } else if (Character.isLetterOrDigit(c.charValue())) {
                nc.append(c);
            } else {
                nc.append('x');
            }
            ++i;
        }
        candidateName = nc.toString();
        return candidateName;
    }

    public static boolean isNameValid(String uncheckedString) {
        return NamingUtils.isNameValid(uncheckedString, 15);
    }

    public static boolean isNameValid(String uncheckedString, int maxNameLength) {
        if (uncheckedString == null || uncheckedString.trim().length() == 0) {
            return false;
        }
        uncheckedString = uncheckedString.trim();
        int i = 0;
        while (i < uncheckedString.length()) {
            Character c = Character.valueOf(uncheckedString.charAt(i));
            if (i == 0 ? !Character.isLetter(c.charValue()) : c.charValue() != ' ' && !Character.isLetterOrDigit(c.charValue()) && c.charValue() != '_') {
                return false;
            }
            ++i;
        }
        return uncheckedString.length() <= maxNameLength;
    }

    public static boolean hasAppendedNumber(String name) {
        int appendedNumber = NamingUtils.getAppendedNumberFromName(name);
        return appendedNumber > -1;
    }

    public static int getAppendedNumberFromName(String name) {
        if (name == null || name.isEmpty() || name.endsWith("_")) {
            return -1;
        }
        String[] splittedName = name.trim().split("_");
        String lastPart = splittedName[splittedName.length - 1];
        if (PrimitiveUtils.isInteger(lastPart)) {
            return Integer.parseInt(lastPart);
        }
        return -1;
    }

    public static String replaceAppendedNumber(String name, int newNumber) {
        if (!NamingUtils.hasAppendedNumber(name)) {
            return name;
        }
        int numberIndex = name.lastIndexOf("_");
        return String.valueOf(name.substring(0, numberIndex + 1)) + newNumber;
    }

    public static String addNumberToEndOfString(String name, int numberToAppend) {
        if (name == null) {
            return "_" + numberToAppend;
        }
        return String.valueOf(name) + "_" + numberToAppend;
    }

    public static String createUniqueName(String name, Set<String> usedNames) {
        return NamingUtils.createUniqueName(name, usedNames, 15);
    }

    public static String createUniqueName(String name, Set<String> usedNames, int maxLengthOfName) {
        if (!usedNames.contains(name)) {
            return name;
        }
        name = NamingUtils.stripNumbersOffEndOfName(name);
        String newUniqueName = name = NamingUtils.truncateName(name, maxLengthOfName - 2);
        boolean cleared = false;
        int i = 1;
        while (!cleared) {
            if (i == 10 && name.length() > maxLengthOfName - 3) {
                name = name.substring(0, name.length() - 1);
            }
            if (i == 100 && name.length() > maxLengthOfName - 4) {
                name = name.substring(0, name.length() - 1);
            }
            newUniqueName = String.valueOf(name) + "_" + i;
            boolean foundConflict = false;
            if (usedNames.contains(newUniqueName)) {
                foundConflict = true;
            }
            if (!foundConflict) {
                cleared = true;
                continue;
            }
            ++i;
        }
        return newUniqueName;
    }

    public static String replaceSpacesWithUnderscores(String str) {
        return str.trim().replace(" ", "_");
    }

    public static String makeFirstCharLetter(String candidate) {
        if (!Character.isLetter(candidate.charAt(0))) {
            return "P" + candidate;
        }
        return candidate;
    }

    public static String makeLegalCharacters(String candidate) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < candidate.length()) {
            char c = candidate.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '_': {
                    sb.append('_');
                    break;
                }
                default: {
                    if (!Character.isLetterOrDigit(c)) break;
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String makeReservedNamePrefixed(String candidate, String[] reservedNames) {
        String[] stringArray = reservedNames;
        int n = reservedNames.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            if (candidate.equals(each)) {
                return "P" + candidate;
            }
            ++n2;
        }
        return candidate;
    }
}

