/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.StringUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Scanner;

public class PrimitiveUtils {
    public static final DecimalFormat WHOLE_NUMBER_FORMAT = DecimalFormatFactory.createHalfUpDecimalFormat("0");

    private PrimitiveUtils() {
    }

    public static double between(double value, double min, double max) {
        if (min > max) {
            return PrimitiveUtils.between(value, max, min);
        }
        value = Math.max(value, min);
        value = Math.min(value, max);
        return value;
    }

    public static int between(int value, int min, int max) {
        if (min > max) {
            return PrimitiveUtils.between(value, max, min);
        }
        value = Math.max(value, min);
        value = Math.min(value, max);
        return value;
    }

    public static boolean isWithinRange(double value, double minimum, double maximum) {
        return value >= minimum && value <= maximum;
    }

    public static double parseDouble(String text, double defaultValue) {
        try {
            return PrimitiveUtils.parseDouble(text);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static double parseDouble(String text) {
        return Double.valueOf(text.replace(",", "."));
    }

    public static float parseFloat(String text, float defaultValue) {
        try {
            return PrimitiveUtils.parseFloat(text);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static float parseFloat(String text) {
        return Float.valueOf(text.replace(",", ".")).floatValue();
    }

    public static int parseInteger(String text, int defaultValue) {
        try {
            return Integer.valueOf(text);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T parseEnum(String value, Class<T> type, T defaultValue) {
        try {
            Enum[] enumArray = (Enum[])type.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum each = enumArray[n2];
                if (value.equalsIgnoreCase(each.name())) {
                    return (T)each;
                }
                ++n2;
            }
            return Enum.valueOf(type, value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T[] parseEnumArray(String[] values, Class<T> type) {
        Enum[] result = (Enum[])Array.newInstance(type, values.length);
        int i = 0;
        while (i < values.length) {
            result[i] = PrimitiveUtils.parseEnum(values[i], type, null);
            ++i;
        }
        return result;
    }

    public static int[] parseIntegerArray(String[] resultAsArray) {
        int[] result = new int[resultAsArray.length];
        int i = 0;
        while (i < resultAsArray.length) {
            result[i] = Integer.parseInt(resultAsArray[i]);
            ++i;
        }
        return result;
    }

    public static long[] parseLongArray(String[] resultAsArray) {
        long[] result = new long[resultAsArray.length];
        int i = 0;
        while (i < resultAsArray.length) {
            result[i] = Long.parseLong(resultAsArray[i]);
            ++i;
        }
        return result;
    }

    public static float[] parseFloatArray(String[] resultAsArray) {
        float[] result = new float[resultAsArray.length];
        int i = 0;
        while (i < resultAsArray.length) {
            result[i] = Float.parseFloat(resultAsArray[i]);
            ++i;
        }
        return result;
    }

    public static double[] parseDoubleArray(String[] resultAsArray) {
        double[] result = new double[resultAsArray.length];
        int i = 0;
        while (i < resultAsArray.length) {
            result[i] = PrimitiveUtils.parseDouble(resultAsArray[i]);
            ++i;
        }
        return result;
    }

    public static boolean[] parseBooleanArray(String[] resultAsArray) {
        boolean[] result = new boolean[resultAsArray.length];
        int i = 0;
        while (i < resultAsArray.length) {
            result[i] = Boolean.parseBoolean(resultAsArray[i]);
            ++i;
        }
        return result;
    }

    public static int getDecimals(double value) {
        return new BigDecimal(Double.toString(value)).stripTrailingZeros().scale();
    }

    public static String moveNumberIfLower(String leader, String follower) {
        if (StringUtils.isNullOrOnlyWhitespace(leader) || StringUtils.isNullOrOnlyWhitespace(follower)) {
            return null;
        }
        try {
            double leader_d = PrimitiveUtils.parseDouble(leader);
            double follower_d = PrimitiveUtils.parseDouble(follower);
            if (leader_d <= follower_d) {
                return leader;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return null;
    }

    public static double applyDecimalFormat(DecimalFormat decimalFormat, double number) {
        DecimalFormatFactory.applyDefaultMinusSignsAndNegativePrefix(decimalFormat);
        String result = decimalFormat.format(number);
        return PrimitiveUtils.parseDouble(result);
    }

    public static boolean[] initArray(boolean withValue, int ofLength) {
        return PrimitiveUtils.initArray(new boolean[ofLength], withValue);
    }

    public static boolean[] initArray(boolean[] array, boolean value) {
        Arrays.fill(array, value);
        return array;
    }

    public static double[] initArray(double withValue, int ofLength) {
        return PrimitiveUtils.initArray(new double[ofLength], withValue);
    }

    public static double[] initArray(double[] array, double value) {
        Arrays.fill(array, value);
        return array;
    }

    public static int[] initArray(int[] array, int value) {
        Arrays.fill(array, value);
        return array;
    }

    public static int[] initArray(int withValue, int ofLength) {
        return PrimitiveUtils.initArray(new int[ofLength], withValue);
    }

    public static byte[] initArray(byte[] array, byte value) {
        Arrays.fill(array, value);
        return array;
    }

    public static <T> T[] initArray(T[] array, T value) {
        Arrays.fill(array, value);
        return array;
    }

    public static boolean isInteger(String uncheckedString) {
        if (StringUtils.isNullOrOnlyWhitespace(uncheckedString)) {
            return false;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner scanner = new Scanner(uncheckedString);){
            if (scanner.hasNextInt()) {
                scanner.nextInt();
                boolean bl = !scanner.hasNext();
                return bl;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return false;
    }

    public static boolean allSameValue(boolean[] verifiedAsToggled, boolean b) {
        boolean[] blArray = verifiedAsToggled;
        int n = verifiedAsToggled.length;
        int n2 = 0;
        while (n2 < n) {
            boolean value = blArray[n2];
            if (value != b) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

